% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pet.R
\name{pet}
\alias{pet}
\title{Percent exceeding the trend}
\usage{
pet(data, dvar, pvar, mvar, ci = 0.95, decreasing = FALSE, phases = c(1, 2))
}
\arguments{
\item{data}{A single-case data frame. See \code{\link[=scdf]{scdf()}} to learn about this
format.}

\item{dvar}{Character string with the name of the dependent variable.
Defaults to the attributes in the scdf file.}

\item{pvar}{Character string with the name of the phase variable. Defaults to
the attributes in the scdf file.}

\item{mvar}{Character string with the name of the measurement time variable.
Defaults to the attributes in the scdf file.}

\item{ci}{Width of the confidence interval. Default is \code{ci = 0.95}.}

\item{decreasing}{If you expect data to be lower in the B phase, set
\code{decreasing = TRUE}. Default is \code{decreasing = FALSE}.}

\item{phases}{A vector of two characters or numbers indicating the two phases
that should be compared. E.g., \code{phases = c("A","C")} or \code{phases = c(2,4)}
for comparing the second to the fourth phase. Phases could be combined by
providing a list with two elements. E.g., \code{phases = list(A = c(1,3), B = c(2,4))} will compare phases 1 and 3 (as A) against 2 and 4 (as B). Default
is \code{phases = c(1,2)}.}
}
\value{
\tabular{ll}{
    \tab  \cr
   \code{PET} \tab Percent exceeding the trend. \cr
   \code{ci} \tab Width of confidence interval. \cr
   \code{decreasing} \tab Logical argument from function call (see Arguments above). \cr
}
}
\description{
The \code{pet} function returns the percentage of Phase B data points that exceed
the prediction based on the Phase A trend. A binomial test against a 50/50
distribution is calculated. It also calculates the percentage of Phase B data
points that exceed the upper (or lower) 95 percent confidence interval of the
predicted progression.
}
\examples{

## Calculate the PET and use a 99\%-CI for the additional calculation
# create random example data
design <- design(n = 5, slope = 0.2)
dat <- random_scdf(design, seed = 23)
pet(dat, ci = .99)

}
\seealso{
Other overlap functions: 
\code{\link{cdc}()},
\code{\link{ird}()},
\code{\link{nap}()},
\code{\link{overlap}()},
\code{\link{pand}()},
\code{\link{pem}()},
\code{\link{pnd}()},
\code{\link{tau_u}()}
}
\author{
Juergen Wilbert
}
\concept{overlap functions}
