% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zones.R
\name{flexible_zones}
\alias{flexible_zones}
\title{Computes the flexibly shaped zones as in Tango (2005).}
\usage{
flexible_zones(k_nearest, adjacency_matrix, .parallel = FALSE,
  .paropts = NULL)
}
\arguments{
\item{k_nearest}{An integer matrix of the \eqn{k} nearest neighbors for each 
location. Each row corresponds to a location, with the first element of 
each row being the location itself. Locations should be encoded as 
integers.}

\item{adjacency_matrix}{A boolean matrix, with element \eqn{(i,j)} set 
to TRUE if location \eqn{j} is adjacent to location \eqn{i}.}

\item{.parallel}{if \code{TRUE}, apply function in parallel, using parallel
backend provided by foreach}

\item{.paropts}{a list of additional options passed into
the \code{\link[foreach]{foreach}} function when parallel computation
is enabled.  This is important if (for example) your code relies on
external data or packages: use the \code{.export} and \code{.packages}
arguments to supply them so that all cluster nodes have the correct
environment set up for computing.}
}
\value{
A list of integer vectors.
}
\description{
Given a matrix of \eqn{k} nearest neighbors and an adjacency matrix
for the locations involved, produces the set of flexibly shaped zones
as a list of integer vectors. The locations in these zones are all connected, 
in the sense that any location in the zone can be reached from another by 
traveling through adjacent locations within the zone.
}
\examples{
A <- matrix(c(0,1,0,0,0,0,
              1,0,1,0,0,0,
              0,1,0,0,0,0,
              0,0,0,0,1,0,
              0,0,0,1,0,0,
              0,0,0,0,0,0), 
              nrow = 6, byrow = TRUE) == 1
nn <- matrix(as.integer(c(1,2,3,4,5,6,
                          2,1,3,4,5,6,
                          3,2,1,4,5,6,
                          4,5,1,6,3,2,
                          5,4,6,1,3,2,
                          6,5,4,1,3,2)),
                          nrow = 6, byrow = TRUE)
flexible_zones(nn, A)
}
\references{
Tango, T. & Takahashi, K. (2005), \emph{A flexibly shaped spatial scan 
   statistic for detecting clusters}, International Journal of Health 
   Geographics 4(1).
}

