% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hst.R
\name{hst.extract_header}
\alias{hst.extract_header}
\title{Extract header from hst file.}
\usage{
hst.extract_header(filename)
}
\arguments{
\item{filename}{The filename}
}
\value{
A string containing the header
}
\description{
Extract header from hst file.
}
\examples{

# import some of the data included with the package
infile <- system.file("extdata", "example1_hst.hst", package = "scbursts")

open_table <- hst.read(infile, extract="open")
closed_table <- hst.read(infile, extract="closed")
header <- hst.extract_header(infile)

# Make adjustments to the histogram, if you wish
hst.write(open_table, closed_table, file=file.path(tempdir(), "output_hist.hst"), header=header)

}
