% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{process_cond}
\alias{process_cond}
\title{Process Condition Variable}
\usage{
process_cond(.df, .cond, cond_levels, cond_labels)
}
\arguments{
\item{.df}{A data frame containing the data to be processed. Must contain a column
specified by \code{.cond}.}

\item{.cond}{The name of the column in \code{.df} that contains the condition variable.}

\item{cond_levels}{(Optional) A vector of values indicating the order of condition
levels. This is used to set the factor levels of the condition
variable.}

\item{cond_labels}{(Optional) A vector of labels corresponding to the condition
levels. These are used for the legend. If not provided, the
\code{cond_levels} are used as labels.}
}
\value{
The input data frame \code{.df} with the condition variable processed as a factor
with the specified levels and labels.
}
\description{
This is an internal helper function used by \code{raw_plot} and \code{randomization_test}
to process the condition variable in the input data frame. It sets the factor
levels and labels of the condition variable based on the provided \code{cond_levels}
and \code{cond_labels} parameters.
}
\keyword{internal}
