% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predicates.R
\name{is_whole_number}
\alias{is_whole_number}
\title{Check if a vector has all whole numbers}
\usage{
is_whole_number(x)
}
\arguments{
\item{x}{A vector}
}
\value{
TRUE if all elements are whole numbers (NA ignored)
}
\description{
Similar to `is_positive_integer()` but without the constraint that the
underlying data type is actually integer. Useful if the numbers are stored
as `numeric` but you want to check that they are whole.
}
\details{
`NA`s are ignored.
}
\examples{
is_whole_number(c(2.0, 4.0)) # TRUE
is_whole_number(c(-1.4)) # FALSE
}
