% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{univariate}
\alias{univariate}
\title{Univariate analysis of variables}
\usage{
univariate(base, target, threshold)
}
\arguments{
\item{base}{input dataframe}

\item{target}{column / field name for the target variable to be passed as string (must be 0/1 type)}

\item{threshold}{sparsity threshold, to be provided as decimal/fraction}
}
\value{
The function returns an object of class "univariate" which is a list containing the following components:

\item{univar_table}{univariate summary of variables}

\item{num_var_name}{array of column names of numerical type variables}

\item{char_var_name}{array of column names of categorical type variables}

\item{sparse_var_name}{array of column names where population concentration at a class or value is more then the sparsity threshold}
}
\description{
The function gives univariate analysis of the variables as output dataframe. The univariate statistics includes - minimum, maximum, mean, median, number of distinct values, variable type, counts of null value, percentage of null value, maximum population percentage among all classes/values, correlation with target. It also returns the list of names of character and numerical variable types along with variable name with population concentration more than a threshold at a class/value.
}
\examples{
data <- iris
data$Species <- as.character(data$Species)
data$Y <- sample(0:1,size=nrow(data),replace=TRUE)

univariate_list <- univariate(base = data,target = "Y",threshold = 0.95)
univariate_list$univar_table
univariate_list$num_var_name
univariate_list$char_var_name
univariate_list$sparse_var_name
}
\author{
Arya Poddar <aryapoddar290990@gmail.com>
}
