% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics_point_forecasts.R
\name{mse}
\alias{mse}
\title{Mean Squared Error}
\usage{
mse(true_values, predictions)
}
\arguments{
\item{true_values}{A vector with the true observed values of size n}

\item{predictions}{A vector with predicted values of size n}
}
\value{
vector with the scoring values
}
\description{
Mean Squared Error MSE of point forecasts.
Calculated as

\deqn{
  mean((true_values - predicted_values)^2)
}
}
\examples{
true_values <- rnorm(30, mean = 1:30)
predicted_values <- rnorm(30, mean = 1:30)
mse(true_values, predicted_values)
}
