% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input-check-helpers.R
\name{check_predictions}
\alias{check_predictions}
\title{Check Prediction Input For Lower-level Scoring Functions}
\usage{
check_predictions(
  predictions,
  true_values = NULL,
  type = c("continuous", "integer", "binary"),
  class = c("vector", "matrix")
)
}
\arguments{
\item{predictions}{an object with predictions. Depending on whether
\code{class = vector} or \code{class = "matrix"} this can be either a vector of length
n (corresponding to the length of the true_values) or a nxN matrix of
predictive samples, n (number of rows) being the number of data points and
N (number of columns) the number of Monte Carlo samples}

\item{true_values}{A vector with the true observed values of size n}

\item{type}{character, one of "continuous" (default), "integer" or "binary" that
defines the type of the forecast}

\item{class}{character, either "vector" (default) or "matrix" that determines the
class the input has to correspond to}
}
\description{
Helper function to check inputs for lower-level score functions.
}
\keyword{internal}
