% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics-nominal.R
\name{assert_input_nominal}
\alias{assert_input_nominal}
\title{Assert that inputs are correct for nominal forecasts}
\usage{
assert_input_nominal(observed, predicted, predicted_label)
}
\arguments{
\item{observed}{Input to be checked. Should be a factor of length n with
N levels holding the observed values. n is the number of observations and
N is the number of possible outcomes the observed values can assume.
output)}

\item{predicted}{Input to be checked. \code{predicted} should be a vector of
length n, holding probabilities. Alternatively, \code{predicted} can be a matrix
of size n x 1. Values represent the probability that
the corresponding value in \code{observed} will be equal to the highest
available factor level.}

\item{predicted_label}{Factor of length N with N levels, where N is the
number of possible outcomes the observed values can assume.}
}
\value{
Returns NULL invisibly if the assertion was successful and throws an
error otherwise.
}
\description{
Function assesses whether the inputs correspond to the
requirements for scoring nominal forecasts.
}
\keyword{internal_input_check}
