% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scoutbar.R
\name{scoutbar}
\alias{scoutbar}
\alias{update_scoutbar}
\title{Creates a Scoutbar React widget}
\usage{
scoutbar(
  inputId,
  theme = c("light", "dark", "auto"),
  placeholder = list("Hello", "Type some text"),
  actions = list(),
  ...
)

update_scoutbar(session = shiny::getDefaultReactiveDomain(), inputId, ...)
}
\arguments{
\item{inputId}{Widget input id.}

\item{theme}{Scoutbar theme.}

\item{placeholder}{Scoutbar placeholder text. A string or
a list of strings.}

\item{actions}{Scoutbar actions. Expect \link{scout_action}
or \link{scout_section} and \link{scout_page}. \link{scout_action} can
be nested inside \link{scout_section} and \link{scout_page}.}

\item{...}{Scoutbar configuration. Expect a list of properties
like in \link{scoutbar}. See possible values here at \url{https://www.scoutbar.co/docs/features}.}

\item{session}{Shiny session object.}
}
\value{
A list of shiny tags containing all the web dependencies
and scoutbar elements required to instantiate the Scoutbar React widget from
JavaScript.

This function is called for its side effect. It sends a message to JavaScript
through the current websocket connection, leveraging the shiny session object.
}
\description{
Scoutbar react widget for Shiny.

Use this function from the server side of
your Shiny app to update a \link{scoutbar}.
}
\details{
Provides a contextual menu users can activate
with keyboard shortcut or prommatically with \link{update_scoutbar}.
Scoutbar may be seen as an alternative to sidebars and navbars, as it allows
to construct better navigation menus.
}
