% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scs.R
\name{scs}
\alias{scs}
\title{SCS - Splitting Conic Solver}
\usage{
scs(A, b, obj, cone, control = scs_control())
}
\arguments{
\item{A}{a matrix of constraint coefficients. 
\bold{NOTE:} The rows of matrix A have to be ordered according to the 
order given in subsection \dQuote{Allowed cone parameters}.}

\item{b}{a numeric vector giving the primal constraints}

\item{obj}{a numeric vector giving the primal objective}

\item{cone}{a list giving the cone sizes}

\item{control}{a list giving the control parameters.}
}
\value{
list of solution vectors x, y, s and information about run
}
\description{
Solves convex cone programs via operator splitting.
}
\details{
\subsection{Important Note}{ \cr
The order of the rows in matrix \eqn{A} has to correspond to the order given in 
the table \dQuote{Cone Arguments}, which means means rows corresponding to 
\emph{primal zero cones} should be first, rows corresponding to \emph{non-negative cones} second, 
rows corresponding to \emph{second-order cone} third, rows corresponding to \emph{positive semidefinite cones} fourth, 
rows corresponding to \emph{exponential cones} fifth and rows corresponding to \emph{power cones} at last.
}

\subsection{SCS can solve}{
\enumerate{
  \item linear programs (LPs)
  \item second-order cone programs (SOCPs)
  \item semidefinite programs (SDPs)
  \item exponential cone programs (ECPs)
  \item power cone programs (PCPs)
  \item problems with any combination of cones, which can be defined by the parameters listed in the subsection \dQuote{Allowed cone parameters}
} }

\subsection{Allowed \emph{cone} parameters are}{
\tabular{rllll}{ 
   \tab \bold{Parameter} \tab \bold{Type} \tab \bold{Length} \tab \bold{Description}                       \cr
   \tab \code{f}         \tab integer     \tab \eqn{1}       \tab number of primal zero cones (dual free cones),       \cr
   \tab                  \tab             \tab               \tab which corresponds to the primal equality constraints \cr
   \tab \code{l}         \tab integer     \tab \eqn{1}       \tab number of linear cones (non-negative cones)          \cr
   \tab \code{q}         \tab integer     \tab \eqn{\geq1}   \tab vector of second-order cone sizes                    \cr
   \tab \code{s}         \tab integer     \tab \eqn{\geq1}   \tab vector of positive semidefinite cone sizes           \cr
   \tab \code{ep}        \tab integer     \tab \eqn{1}       \tab number of primal exponential cones                   \cr
   \tab \code{ed}        \tab integer     \tab \eqn{1}       \tab number of dual exponential cones                     \cr
   \tab \code{p}         \tab numeric     \tab \eqn{\geq1}   \tab vector of primal/dual power cone parameters          
} }
}
\examples{
A <- matrix(c(1, 1), ncol=1)
b <- c(1, 1)
obj <- 1
cone <- list(f = 2)
control <- list(eps = 1e-3, max_iters = 50)
sol <- scs(A, b, obj, cone, control) 
sol
}
