% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sdc_descriptives.R
\name{sdc_descriptives}
\alias{sdc_descriptives}
\title{Disclosure control for descriptive statistics}
\usage{
sdc_descriptives(
  data,
  id_var = getOption("sdc.id_var"),
  val_var = NULL,
  by = NULL,
  zero_as_NA = NULL
)
}
\arguments{
\item{data}{\link{data.frame} from which the descriptive statistics are
calculated.}

\item{id_var}{\link{character} The name of the id variable. Defaults to \code{ getOption("sdc.id_var")} so that you can provide \code{options(sdc.id_var = "my_id_var")} at the top of your script.}

\item{val_var}{\link{character} vector of value variables on which descriptive
statistics are computed.}

\item{by}{\link{character} vector of grouping variables.}

\item{zero_as_NA}{\link{logical} If TRUE, zeros in 'val_var' are treated as NA.}
}
\value{
A \link{list} of class \code{sdc_descriptives} with detailed information about
options, settings, and compliance with the criteria distinct entities and
dominance.
}
\description{
Checks the number of distinct entities and the (n, k)
dominance rule for your descriptive statistics.

That means that \code{sdc_descriptives()} checks if there are at least 5
distinct entities and if the largest 2 entities account for 85\% or more of
\code{val_var}. The parameters can be changed using options. For details see
\code{vignette("options", package = "sdcLog")}.
}
\details{
\loadmathjax
The general form of the \mjseqn{(n, k)} dominance rule can be formulated
as:

\mjsdeqn{\sum_{i=1}^{n}x_i > \frac{k}{100} \sum_{i=1}^{N}x_i}

where \mjseqn{x_1 \ge x_2 \ge \cdots \ge x_{N}}. \mjseqn{n} denotes the
number of largest contributions to be considered, \mjseqn{x_n} the
\mjseqn{n}-th largest contribution, \mjseqn{k} the maximal percentage these
\mjseqn{n} contributions may account for, and \mjseqn{N} is the total
number of observations.

If the statement above is true, the \mjseqn{(n, k)} dominance rule is
violated.
}
\examples{
sdc_descriptives(
  data = sdc_descriptives_DT,
  id_var = "id",
  val_var = "val_1"
)

sdc_descriptives(
  data = sdc_descriptives_DT,
  id_var = "id",
  val_var = "val_1",
  by = "sector"
)

sdc_descriptives(
  data = sdc_descriptives_DT,
  id_var = "id",
  val_var = "val_1",
  by = c("sector", "year")
)

sdc_descriptives(
  data = sdc_descriptives_DT,
  id_var = "id",
  val_var = "val_2",
  by = c("sector", "year")
)

sdc_descriptives(
  data = sdc_descriptives_DT,
  id_var = "id",
  val_var = "val_2",
  by = c("sector", "year"),
  zero_as_NA = FALSE
)

}
