% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GUIfunctions.R
\docType{methods}
\name{groupVars}
\alias{groupVars}
\alias{groupVars,sdcMicroObj-method}
\alias{groupVars-methods}
\title{Join levels of a keyVariable in an object of class \code{\link{sdcMicroObj-class}}}
\usage{
groupVars(obj, var, before, after)
}
\arguments{
\item{obj}{object of class \code{\link{sdcMicroObj-class}}}

\item{var}{name of the keyVariable to change}

\item{before}{vector of levels before recoding}

\item{after}{vector of levels after recoding}
}
\value{
the modified \code{\link{sdcMicroObj-class}}
}
\description{
Transforms the factor variable into a factors with less levels and
recomputes risk.
}
\section{Methods}{
 \describe{
\item{list("signature(obj = \"sdcMicroObj\")")}{
This method transform a factor variable with some levels into a new factor
variable with less levels. The user must make sure that all levels of the
original variable are listed in argument 'before' and that the number of
elements in argument 'after' (the new levels) have the same length. This
means that there should be a one to one mapping from any level of the
original factor to a level in the recoded variable. } }
}
\examples{

## for objects of class sdcMicro:
data(testdata2)
testdata2$urbrur <- as.factor(testdata2$urbrur)
sdc <- createSdcObj(testdata2,
  keyVars=c('urbrur','roof','walls','water','electcon','relat','sex'),
  numVars=c('expend','income','savings'), w='sampling_weight')
sdc <- groupVars(sdc, var="urbrur", before=c("1","2"), after=c("1","1"))

}
\keyword{methods}

