% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cell_info.R
\name{cell_info}
\alias{cell_info}
\title{Get information about specific cells}
\usage{
cell_info(object, specs, ...)
}
\arguments{
\item{object}{an object of class \linkS4class{sdcProblem}}

\item{specs}{input that defines which cells to query; the function expects
either (see examples below)
\itemize{
\item a named character vector: with names referring to the names of the dimensional
variables and the values to its labels. In this case each vector-element must
contain a single value (label)
\item a \code{data.frame} where the column-names refer to the names of the dimensional
variables and the values to the labels
}}

\item{...}{additional parameters for potential future use, currently unused.}
}
\value{
a \code{data.frame} with a row for each of the queried cells; the object
contains the following columns:
\itemize{
\item id: numeric vector of length 1 specifying the numerical index of the cell
\item a column \code{strID} if \code{object} has not yet been protected
\item one column for each dimensional variable
\item a column \code{freq} containing the cell-frequencies
\item if available, one column for each (possible) numerical value that was tabulated
\item a column \code{sdcStatus} with the current sdc code
\item is_primsupp: is \code{TRUE} if the cell is a primary sensitive cell
\item is_secondsupp: is \code{TRUE} if the cell is a secondary suppressed cell
}
}
\description{
Function \code{\link[=cellInfo]{cellInfo()}} can be used to query information of a single cell
from a \linkS4class{sdcProblem} object. If the instance has already been protected
using \code{\link[=protectTable]{protectTable()}}, the information is retrieved from the final protected
dataset, otherwise from the current state of the instance.
}
\examples{
# as in makeProblem() with a single primary suppression
p <- sdc_testproblem(with_supps = TRUE)
sdcProb2df(p)

# vector input
specs_vec <- c(region = "D", gender = "male")
cell_info(p, specs = specs_vec)

# data.frame input
specs_df <- data.frame(
  region = c("A", "D", "A"),
  gender = c("male", "female", "female")
)
cell_info(p, specs = specs_df)

# protect the table
p_safe <- protectTable(p, method = "SIMPLEHEURISTIC")

# re-apply
cell_info(p_safe, specs = specs_df)

}
\author{
Bernhard Meindl \email{bernhard.meindl@statistik.gv.at}
}
