% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{stepAheadWn1D}
\alias{stepAheadWn1D}
\title{Multiple simulation of trajectory ends of the WN or vM diffusion in 1D}
\usage{
stepAheadWn1D(x0, alpha, mu, sigma, M, N = 100L, delta = 0.01, type = 1L,
  maxK = 2L, expTrc = 30)
}
\arguments{
\item{x0}{vector of length \code{nx0} giving the initial points.}

\item{alpha}{drift parameter.}

\item{mu}{mean parameter. Must be in \eqn{[\pi,\pi)}.}

\item{sigma}{diffusion coefficient.}

\item{M}{number of Monte Carlo replicates.}

\item{N}{number of discretization steps.}

\item{delta}{discretization step.}

\item{type}{integer giving the type of diffusion. Currently, only \code{1} for WN and \code{2} for vM are supported.}

\item{maxK}{maximum absolute value of the windings considered in the computation of the WN.}

\item{expTrc}{truncation for exponential: \code{exp(x)} with \code{x <= -expTrc} is set to zero. Defaults to \code{30}.}
}
\value{
A matrix of size \code{c(nx0, M)} containing the \code{M} trajectory ends for each starting value \code{x0}.
}
\description{
Simulates \code{M} trajectories starting from different initial values \code{x0} of the WN or vM diffusion in 1D, by the Euler method, and returns their ends.
}
\examples{
N <- 100
nx0 <- 20
x0 <- seq(-pi, pi, l = nx0 + 1)[-(nx0 + 1)]
set.seed(12345678)
samp1 <- euler1D(x0 = x0, mu = 0, alpha = 3, sigma = 1, N = N,
                 delta = 0.01, type = 2)
tt <- seq(0, 1, l = N + 1)
plot(rep(0, nx0), x0, pch = 16, col = rainbow(nx0), xlim = c(0, 1))
for (i in 1:nx0) linesCirc(tt, samp1[i, ], col = rainbow(nx0)[i])
set.seed(12345678)
samp2 <- stepAheadWn1D(x0 = x0, mu = 0, alpha = 3, sigma = 1, M = 1,
                       N = N, delta = 0.01, type = 2)
points(rep(1, nx0), samp2[, 1], pch = 16, col = rainbow(nx0))
samp1[, N + 1]
samp2[, 1]
}
