% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WOU.R
\name{dTpdWou}
\alias{dTpdWou}
\title{Conditional probability density of the WOU process}
\usage{
dTpdWou(x, t, A, mu, Sigma, x0, maxK = 2, eigA = NULL, invASigma = NULL)
}
\arguments{
\item{x}{matrix of size \code{c(n, p)} with the evaluation points in
\eqn{[-\pi,\pi)^p}.}

\item{t}{a scalar containing the times separating \code{x} and \code{x0}.}

\item{A}{matrix of size \code{c(p, p)} giving the drift strength.}

\item{mu}{mean parameter. Must be in \eqn{[\pi,\pi)}.}

\item{Sigma}{diffusion matrix, of size \code{c(p, p)}.}

\item{x0}{vector of length \code{p} with the initial point in
\eqn{[-\pi,\pi)^p}.}

\item{maxK}{maximum absolute value of the windings considered in the computation of the WN.}

\item{eigA}{optional argument containing \code{eigen(A)} for reuse.}

\item{invASigma}{the matrix \code{solve(Sigma) \%*\% A} (optional).}
}
\value{
A vector of length \code{n} with the density evaluated at \code{x}.
}
\description{
Conditional probability density of the Wrapped
Ornstein--Uhlenbeck (WOU) process.
}
\details{
See Section 3.3 in García-Portugués et al. (2019) for details.
\code{\link{dTpdWou1D}} and \code{\link{dTpdWou2D}} are more efficient
implementations for the 1D and 2D cases, respectively.
}
\examples{
# 1D
t <- 0.5
alpha <- 1
mu <- 0
sigma <- 1
x0 <- pi
x <- seq(-pi, pi, l = 10)
dTpdWou(x = cbind(x), x0 = x0, t = t, A = alpha, mu = 0, Sigma = sigma^2) -
dTpdWou1D(x = cbind(x), x0 = rep(x0, 10), t = t, alpha = alpha, mu = 0,
          sigma = sigma)

# 2D
t <- 0.5
alpha <- c(2, 1, -1)
sigma <- c(1.5, 2)
rho <- 0.9
Sigma <- diag(sigma^2)
Sigma[1, 2] <- Sigma[2, 1] <- rho * prod(sigma)
A <- alphaToA(alpha = alpha, sigma = sigma, rho = rho)
mu <- c(pi, 0)
x0 <- c(0, 0)
x <- seq(-pi, pi, l = 5)
x <- as.matrix(expand.grid(x, x))
dTpdWou(x = x, x0 = x0, t = t, A = A, mu = mu, Sigma = Sigma) -
dTpdWou2D(x = x, x0 = rbind(x0), t = t, alpha = alpha, mu = mu,
          sigma = sigma, rho = rho)
}
\references{
García-Portugués, E., Sørensen, M., Mardia, K. V. and Hamelryck, T. (2019)
Langevin diffusions on the torus: estimation and applications.
\emph{Statistics and Computing}, 29(2):1--22. \doi{10.1007/s11222-017-9790-2}
}
