% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mask_sensitive_variable.R
\name{replace_lastname}
\alias{replace_lastname}
\title{Replace the lastnames with values from another database.}
\usage{
replace_lastname(dataset, country = "uk", race_dependency = FALSE)
}
\arguments{
\item{dataset}{A data frame of the dataset.}

\item{country}{A string variable with a default of 'uk'. It is either
'uk' or 'us'.}

\item{race_dependency}{A logical variable with a default of FALSE.}
}
\value{
A data frame of the \code{dataset} with the lastname column being replaced
    by another lastname database.
}
\description{
\code{replace_lastname} replaces the lastname in \code{dataset} with lastname from
    another database (see \code{\link{lastname_uk}} and \code{\link{lastname_us}})
    in case they are too sensitive.
}
\examples{
df <- data.frame(sex=sample(c('male', 'female'), 100, replace = TRUE))
df$race <- sample(1:6, 100, replace = TRUE)
df <- add_variable(df, "nhsid")
df <- add_variable(df, "dob", age_dependency = FALSE)
df <- add_variable(df, "firstname", country = "uk", gender_dependency= TRUE, age_dependency = TRUE)
df <- add_variable(df, "lastname", country = "uk", gender_dependency= TRUE, age_dependency = TRUE)
df$firstname <-as.character(df$firstname)
df$lastname <-as.character(df$lastname)
replace_lastname(df, country = 'uk')
replace_lastname(df, country = 'us', race_dependency =TRUE)

}
