% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_plot.R, R/plot.bayesfactor_models.R,
%   R/plot.bayesfactor_savagedickey.R, R/plot.check_distribution.R,
%   R/plot.check_normality.R, R/plot.check_outliers.R,
%   R/plot.equivalence_test.R, R/plot.estimate_density.R, R/plot.rope.R
\name{data_plot}
\alias{data_plot}
\alias{plot.see_bayesfactor_models}
\alias{plot.see_bayesfactor_savagedickey}
\alias{plot.see_check_distribution}
\alias{plot.see_check_normality}
\alias{plot.see_check_outliers}
\alias{plot.see_equivalence_test}
\alias{plot.see_estimate_density}
\alias{plot.see_rope}
\title{Prepare objects for plotting or plot objects}
\usage{
data_plot(x, data = NULL, ...)

\method{plot}{see_bayesfactor_models}(x, n_pies = c("one", "many"),
  value = c("none", "BF", "probability"), log = FALSE,
  prior_odds = NULL, ...)

\method{plot}{see_bayesfactor_savagedickey}(x, point_size = 2, ...)

\method{plot}{see_check_distribution}(x, point_size = 2, panel = TRUE,
  ...)

\method{plot}{see_check_normality}(x, type = c("density", "qq", "pp"),
  data = NULL, ...)

\method{plot}{see_check_outliers}(x, text_size = 3.5, ...)

\method{plot}{see_equivalence_test}(x, rope_color = "#0171D3",
  rope_alpha = 0.2, show_intercept = FALSE, ...)

\method{plot}{see_estimate_density}(x, stack = TRUE,
  show_intercept = FALSE, ...)

\method{plot}{see_rope}(x, data = NULL, rope_alpha = 0.5,
  rope_color = "cadetblue", show_intercept = FALSE, ...)
}
\arguments{
\item{x}{An object.}

\item{data}{The original data used to create this object. Can be a statistical model or such.}

\item{...}{Arguments passed to or from other methods.}

\item{n_pies}{Number of pies.}

\item{value}{What value to display.}

\item{log}{Show log-transformed Bayes factors.}

\item{prior_odds}{optional vector of prior odds for the models. See \code{BayesFactor::priorOdds}.
As the size of the pizza slices corresponds to posterior probability (which is a function of prior probability and the BF),
custom \code{prior_odds} will change the slices' size.}

\item{point_size}{Size of point-geoms.}

\item{panel}{Logical, if \code{TRUE}, plots are arranged as panels; else, single plots are returned.}

\item{type}{Character vector, indicating the type of plot (for
\code{\link[performance]{check_normality}}).}

\item{text_size}{Size of text labels.}

\item{rope_color}{Color of ROPE ribbon.}

\item{rope_alpha}{Transparency level of ROPE ribbon.}

\item{show_intercept}{Logical, if \code{TRUE}, the intercept-parameter is included
in the plot. By default, it is hidden because in many cases the intercept-parameter
has a posterior distribution on a very different location, so density curves of
posterior distributions for other parameters are hardly visible.}

\item{stack}{Logical, if \code{TRUE}, densities are plotted as stacked lines.
Else, densities are plotted for each parameter among each other.}
}
\description{
\code{data_plot()} attempts to extract and tranform an object
to be further plotted, while \code{plot()} tries to visualize results of
functions from different packages of the \href{https://github.com/easystats}{easystats-project}.
}
\details{
\code{data_plot()} is in most situation not needed when the purpose
is plotting, since most \code{plot()}-functions in \pkg{see} internally call
\code{data_plot()} to prepare the data for plotting.
\cr \cr
Many \code{plot()}-functions have a \code{data}-argument that is needed when
the data or model for plotting can't be retrieved via \code{data_plot()}. In
such cases, \code{plot()} gives an error and asks for providing data or models.
\cr \cr
Most \code{plot()}-functions work out-of-the-box, i.e. you don't need to do
much more than calling \code{plot(<object>)} (see 'Examples'). Some plot-functions
allow to specify arguments to modify the transparancy or color of geoms, these
are shown in the 'Usage' section.
\cr \cr
Plot-functions are available for objects from following functions (note that
functions from packages might be listed here that are currently still in
development and probably not yet available):
\itemize{
  \item \code{bayestestR::bayesfactor_models()}
  \item \code{bayestestR::bayesfactor_savagedickey()}
  \item \code{bayestestR::ci()}
  \item \code{bayestestR::equivalence_test()}
  \item \code{bayestestR::estimate_density()}
  \item \code{bayestestR::hdi()}
  \item \code{bayestestR::p_direction()}
  \item \code{bayestestR::rope()}
  \item \code{estimate::estimateContrasts()}
  \item \code{performance::binned_residuals()}
  \item \code{performance::check_collinearity()}
  \item \code{performance::check_distribution()}
  \item \code{performance::check_heteroscedasticity()}
  \item \code{performance::check_homogeneity()}
  \item \code{performance::check_model()}
  \item \code{performance::check_normality()}
  \item \code{performance::check_outliers()}
  \item \code{performance::performance_roc()}
}
}
\examples{
library(bayestestR)
library(rstanarm)

model <- stan_glm(
  Sepal.Length ~ Petal.Width * Species,
  data = iris,
  chains = 2, iter = 200
)

x <- rope(model)
plot(x)

x <- hdi(model)
plot(x) + theme_modern()

\dontrun{
data <- rnorm(1000, 1)
x <- p_direction(data)
plot(x)

x <- p_direction(model)
plot(x)

model <- stan_glm(
  mpg ~ wt + gear + cyl + disp,
  chains = 2,
  iter = 200,
  data = mtcars
)
x <- equivalence_test(model)
plot(x)}

\dontrun{
library(bayestestR)
library(see)

lm0 <- lm(qsec ~ 1, data = mtcars)
lm1 <- lm(qsec ~ drat, data = mtcars)
lm2 <- lm(qsec ~ wt, data = mtcars)
lm3 <- lm(qsec ~ drat + wt, data = mtcars)

result <- bayesfactor_models(lm1, lm2, lm3, denominator = lm0)

plot(result, n_pies = "one", value = "probability") + theme_modern() +
  scale_fill_pizza(reverse = TRUE)
}

}
