% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lda.R, R/seededlda.R
\name{textmodel_lda}
\alias{textmodel_lda}
\alias{textmodel_seededlda}
\title{Semisupervised Latent Dirichlet allocation}
\usage{
textmodel_lda(
  x,
  k = 10,
  max_iter = 2000,
  alpha = NULL,
  beta = NULL,
  verbose = quanteda_options("verbose")
)

textmodel_seededlda(
  x,
  dictionary,
  valuetype = c("glob", "regex", "fixed"),
  case_insensitive = TRUE,
  residual = FALSE,
  weight = 0.01,
  max_iter = 2000,
  alpha = NULL,
  beta = NULL,
  verbose = quanteda_options("verbose")
)
}
\arguments{
\item{x}{the dfm on which the model will be fit}

\item{k}{the number of topics}

\item{max_iter}{the maximum number of iteration in Gibbs sampling.}

\item{alpha}{the hyper parameter for topic-document distribution}

\item{beta}{the hyper parameter for topic-word distribution}

\item{verbose}{logical; if \code{TRUE} print diagnostic information during
fitting.}

\item{dictionary}{a \code{\link[quanteda:dictionary]{quanteda::dictionary()}} with seed words as
examples of topics.}

\item{valuetype}{see \link[quanteda:valuetype]{quanteda::valuetype}}

\item{case_insensitive}{see \link[quanteda:valuetype]{quanteda::valuetype}}

\item{residual}{if \code{TRUE} a residual topic (or "garbage topic") will be
added to user-defined topics.}

\item{weight}{pseudo count given to seed words as a proportion of total
number of words in \code{x}.}
}
\description{
\code{textmodel_seededlda()} implements semisupervised Latent Dirichlet allocation (seeded-LDA).
The estimator's code adopted from the GibbsLDA++ library (Xuan-Hieu Phan,
2007). \code{textmodel_seededlda()} allows identification of pre-defined topics by
semisupervised learning with a seed word dictionary.
}
\examples{
\dontrun{
require(quanteda)

data("data_corpus_moviereviews", package = "quanteda.textmodels")
corp <- head(data_corpus_moviereviews, 500)
dfmt <- dfm(corp, remove_number = TRUE) \%>\%
    dfm_remove(stopwords('en'), min_nchar = 2) \%>\%
    dfm_trim(min_termfreq = 0.90, termfreq_type = "quantile",
             max_docfreq = 0.1, docfreq_type = "prop")

# unsupervised LDA
lda <- textmodel_lda(dfmt, 6)
terms(lda)

# semisupervised LDA
dict <- dictionary(list(people = c("family", "couple", "kids"),
                        space = c("areans", "planet", "space"),
                        moster = c("monster*", "ghost*", "zombie*"),
                        war = c("war", "soldier*", "tanks"),
                        crime = c("crime*", "murder", "killer")))
slda <- textmodel_seededlda(dfmt, dict, residual = TRUE)
terms(slda)
}
}
\references{
Lu, Bin et al. (2011).
\href{https://dl.acm.org/doi/10.5555/2117693.2119585}{Multi-aspect Sentiment Analysis with Topic Models}.
\emph{Proceedings of the 2011 IEEE 11th International Conference on Data Mining Workshops}.

Watanabe, Kohei & Zhou, Yuan (2020).
\href{https://doi.org/10.1177/0894439320907027}{Theory-Driven Analysis of Large Corpora: Semisupervised Topic Classification of the UN Speeches}.
\emph{Social Science Computer Review}.
}
\seealso{
\link[topicmodels:lda]{topicmodels}
}
\keyword{experimental}
\keyword{textmodel}
