% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/salmon.R
\name{salmon}
\alias{salmon}
\title{Run Salmon}
\usage{
salmon(
  filepaths,
  samples,
  indexDir,
  outputDir = "salmon_output",
  cmd = "salmon",
  args = c("-l A -q --seqBias --gcBias --no-version-check -p",
    foreach::getDoParWorkers()),
  compress = TRUE
)
}
\arguments{
\item{filepaths}{Paths to fastq files. For single-end reads, each element
should be a single filepath. For paired-end reads, each element should be
two filepaths separated by ";".}

\item{samples}{Corresponding sample names for fastq files.}

\item{indexDir}{Directory that contains salmon index.}

\item{outputDir}{Directory in which to store output. Will be created if it
doesn't exist.}

\item{cmd}{Name or path of the command-line interface.}

\item{args}{Additional arguments to pass to the command-line interface.}

\item{compress}{Logical indicating whether to gzip the quantification file
(quant.sf) from salmon. Does not affect downstream analysis.}
}
\value{
A vector of exit codes, invisibly.
}
\description{
This function calls
\href{https://combine-lab.github.io/salmon/}{salmon}
using \code{\link[=system2]{system2()}}. To run in parallel, register a parallel backend, e.g.,
using \code{\link[doParallel:registerDoParallel]{doParallel::registerDoParallel()}}.
}
\seealso{
\code{\link[=seeker]{seeker()}}, \code{\link[=getSalmonMetadata]{getSalmonMetadata()}}
}
