% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/std_coeff_fun.R
\name{varW}
\alias{varW}
\title{Weighted Variance}
\usage{
varW(x, w = NULL, na.rm = FALSE, ...)
}
\arguments{
\item{x}{A numeric vector.}

\item{w}{A numeric vector of weights of the same length as \code{x}.}

\item{na.rm}{Logical, whether NA's in \code{x} should be removed.}

\item{...}{Not currently used.}
}
\value{
A numeric value, the weighted variance of \code{x}.
}
\description{
Calculate the weighted variance of \code{x}.
}
\details{
Calculate the weighted variance of \code{x} via the weighted
  covariance matrix (\code{cov.wt}). If no weights are supplied, the simple
  variance is returned instead. As in \code{weighted.mean}, \code{NA}'s in
  \code{w} are not handled specially and will return \code{NA} as result.
}
\examples{
## Weighted variance
x <- rnorm(30)
w <- runif(30, 0, 1)
varW(x, w)

## Simple variance
varW(x)
stopifnot(varW(x) == var(x))

## NA handling
varW(c(x[1:29], NA), w, na.rm = TRUE)  # NA in x (removed)
varW(c(x[1:29], NA), w, na.rm = FALSE)  # NA in x (NA returned)
varW(x[1:29], w = c(w[1:29], NA))  # NA in w (NA returned)
}
\seealso{
\code{\link[stats]{var}}, \code{\link[stats]{cov.wt}},
  \code{\link[stats]{weighted.mean}}
}
