% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_semlbci.R
\name{print.semlbci}
\alias{print.semlbci}
\title{Print Method of a 'semlbci' Object}
\usage{
\method{print}{semlbci}(
  x,
  digits = 3,
  annotation = TRUE,
  time = FALSE,
  verbose = FALSE,
  verbose_if_needed = TRUE,
  drop_no_lbci = TRUE,
  ...
)
}
\arguments{
\item{x}{The output of \code{\link[=semlbci]{semlbci()}}.}

\item{digits}{The number of digits after the decimal point. To be
passed to \code{\link[=formatC]{formatC()}}. Default is 3.}

\item{annotation}{If \code{TRUE}, print table notes. Default is \code{TRUE}.}

\item{time}{If \code{TRUE}, print the time spent on each bound. Default
is \code{FALSE}.}

\item{verbose}{If \code{TRUE}, additional diagnostic information will
always be printed. This argument overrides \code{verbose_if_needed}.
Default is \code{FALSE}.}

\item{verbose_if_needed}{If \code{TRUE}, additional diagnostic
information will be printed only if necessary. If \code{FALSE},
additional diagnostic information will always be printed. Default
is \code{TRUE}.}

\item{drop_no_lbci}{If \code{TRUE}, parameters without LBCIs will be
removed. Default is \code{TRUE}.}

\item{...}{Other arguments. They will be ignored.}
}
\value{
\code{x} is returned invisibly. Called for its side effect.
}
\description{
Prints the results of a \code{semlbci} object, the output
of \code{\link[=semlbci]{semlbci()}}.
}
\details{
Prints the results of \code{\link[=semlbci]{semlbci()}} as a table.
}
\examples{

library(lavaan)
mod <-
"
m ~ a*x
y ~ b*m
ab := a * b
"
fit_med <- sem(mod, simple_med, fixed.x = FALSE)
p_table <- parameterTable(fit_med)
p_table
lbci_med <- semlbci(fit_med,
                    pars = c("ab :="))
lbci_med

print(lbci_med, verbose_if_needed = FALSE)

print(lbci_med, verbose = TRUE)

print(lbci_med, time = TRUE)

print(lbci_med, annotation = FALSE)

print(lbci_med, digits = 4)

}
\seealso{
\code{\link[=semlbci]{semlbci()}}
}
\author{
Shu Fai Cheung \url{https://orcid.org/0000-0002-9871-9448}
}
