% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sendmailR.r
\name{sendmail}
\alias{sendmail}
\title{Send mail from within R}
\usage{
sendmail(
  from,
  to,
  subject,
  msg,
  cc,
  bcc,
  ...,
  headers = list(),
  control = list()
)
}
\arguments{
\item{from}{From whom the mail message is (RFC2822 style address).}

\item{to}{Recipient of the message (vector of valid RFC2822 style addresses).}

\item{subject}{Subject line of message.}

\item{msg}{Body text of message or a list containing
\code{\link{mime_part}} objects.}

\item{cc}{Carbon-copy recipients (vector of valid RFC2822 style addresses).}

\item{bcc}{Blind carbon-copy recipients (vector of valid RFC2822 style addresses).}

\item{\dots}{...}

\item{headers}{Any other headers to include.}

\item{control}{List of SMTP server settings. Valid values are the
possible options for \code{\link{sendmail_options}}.}
}
\description{
Simplistic sendmail utility for R. Uses SMTP to submit a message
to a local SMTP server.
}
\examples{
\dontrun{
from <- sprintf("<sendmailR@\\\\\%s>", Sys.info()[4])
to <- "<olafm@datensplitter.net>"
subject <- "Hello from R"
body <- list("It works!", mime_part(iris))
sendmail(from, to, subject, body,
         control=list(smtpServer="ASPMX.L.GOOGLE.COM"))
}

}
\seealso{
\code{\link{mime_part}} for a way to add attachments.
}
\keyword{utilities}
