% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_sobol.R
\name{plot_multiscatter}
\alias{plot_multiscatter}
\title{Pairwise combinations of model inputs with the colour
proportional the model output value.}
\usage{
plot_multiscatter(data, N, Y, params, smpl = NULL)
}
\arguments{
\item{data}{The matrix created with \code{\link{sobol_matrices}}.}

\item{N}{Positive integer, the initial sample size of the base sample matrix created with \code{\link{sobol_matrices}}.}

\item{Y}{A numeric vector with the model output obtained from the matrix created with
\code{\link{sobol_matrices}}.}

\item{params}{Character vector with the name of the model inputs.}

\item{smpl}{The number of simulations to plot.
The default is NULL.}
}
\value{
A \code{ggplot2} object.
}
\description{
It plots all pairwise combinations of model inputs with the colour
proportional the model output value.
}
\examples{
# Define settings
N <- 1000; params <- paste("X", 1:3, sep = ""); R <- 10

# Create sample matrix
mat <- sobol_matrices(N = N, params = params)

# Compute Ishigami function
Y <- ishigami_Fun(mat)

# Plot scatterplot matrix
plot_multiscatter(data = mat, N = N, Y = Y, params = params)
}
