% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/highlight.R
\name{highlight}
\alias{highlight}
\title{Polarity Text Highlighting}
\usage{
highlight(x, file = file.path(tempdir(), "polarity.html"), open = TRUE,
  digits = 3, ...)
}
\arguments{
\item{x}{A \code{sentiment_by} object.}

\item{file}{A name of the html file output.}

\item{open}{logical.  If \code{TRUE} the text highlighting document will
attempt to be opened.}

\item{digits}{The number of digits to print for each row level average
sentiment score.}

\item{\ldots}{Ignored.}
}
\value{
Generates an html document with text highlighting.
}
\description{
Highlight sentences within elements (row IDs) by sentiment polarity
(positive = green; negative = pink) as an html file.
}
\examples{
library(data.table)
dat <- presidential_debates_2012
setDT(dat)

dat[, gr:={gr= paste(person, time); cumsum(c(TRUE, gr[-1]!= gr[-.N]))}]
dat <- dat[, list(person=person[1L], time=time[1L], dialogue=paste(dialogue,
    collapse = ' ')), by = gr][,gr:= NULL][, 
    dialogue_split := get_sentences(dialogue)][]

(sent_dat <- with(dat, sentiment_by(dialogue_split, list(person, time))))

\dontrun{
highlight(sent_dat)

## tidy approach
library(dplyr)
library(magrittr)

cannon_reviews \%>\%
    filter(number \%in\% sample(unique(number), 3)) \%>\%
    mutate(review = get_sentences(text)) \%$\%
    sentiment_by(review, number) \%>\%
    highlight()
}
}
