% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sentometrics.R
\docType{package}
\name{sentometrics-package}
\alias{sentometrics}
\alias{sentometrics-package}
\title{sentometrics: An Integrated Framework for Textual Sentiment Time Series Aggregation and Prediction}
\description{
The \pkg{sentometrics} package is designed to perform time series analysis based on textual sentiment. It
accounts for the intrinsic challenge that, for a given text, sentiment can be computed in many ways, as well as the large
number of possibilities to pool sentiment across texts and time. This additional layer of manipulation does not exist
in standard text mining and time series analysis packages. The package provides an interface to model
the impact of sentiment in texts on a given variable, by first computing a wide range of textual
sentiment time series and then selecting those that are most informative. Altogether, \pkg{sentometrics} integrates the
fast \emph{qualification} of sentiment from texts, the \emph{aggregation} into different sentiment measures and the optimized
\emph{prediction} based on these measures.
}
\note{
Please cite the package in publications. Use \code{citation("sentometrics")}.
}
\section{Main functions}{

\itemize{
\item Corpus features generation: \code{\link{sento_corpus}}, \code{\link{add_features}}
\item Sentiment computation and aggregation into sentiment measures: \code{\link{ctr_agg}}, \code{\link{sento_lexicons}},
\code{\link{compute_sentiment}}, \code{\link{sento_measures}}, \code{\link{peakdocs}}, and a series of
\code{measures_xyz}, generic and extractor functions
\item Sparse modelling: \code{\link{ctr_model}}, \code{\link{sento_model}}
\item Prediction and post-modelling analysis: \code{\link{predict.sentomodel}}, \code{\link{attributions}},
\code{\link{get_loss_data}}
}
}

\section{Update}{

The development version of the package resides at \url{https://github.com/sborms/sentometrics}.
}

\references{
Ardia, Bluteau and Boudt (2018). ``Questioning the news about economic growth: Sparse forecasting using
thousands of news-based sentiment values''. \emph{Working paper}, \url{http://dx.doi.org/10.2139/ssrn.2976084}.

Ardia, Bluteau, Borms and Boudt (2018). ``The R package sentometrics to compute, aggregate and
predict with textual sentiment''. \emph{Working paper}, \url{http://dx.doi.org/10.2139/ssrn.3067734}.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/sborms/sentometrics}
  \item Report bugs at \url{https://github.com/sborms/sentometrics/issues}
}

}
\author{
\strong{Maintainer}: Samuel Borms \email{samuel.borms@unine.ch}

Authors:
\itemize{
  \item David Ardia \email{david.ardia@unine.ch}
  \item Keven Bluteau \email{keven.bluteau@unine.ch}
  \item Kris Boudt \email{kris.boudt@vub.be}
}

}
