% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conversions.R
\name{LDAvis}
\alias{LDAvis}
\title{Visualize a LDA model using \pkg{LDAvis}}
\usage{
LDAvis(x, ...)
}
\arguments{
\item{x}{an \code{LDA} model}

\item{...}{further arguments passed on to \code{\link[LDAvis:createJSON]{LDAvis::createJSON()}} and
\code{\link[LDAvis:serVis]{LDAvis::serVis()}}.}
}
\value{
Nothing, called for its side effects.
}
\description{
This function call \pkg{LDAvis} to create a dynamic visualization of an
estimated topic model.
}
\details{
The CRAN release of \pkg{LDAvis} does not support UTF-8 characters
and automatically reorder topics. To solve these two issues, please install
the development version of \pkg{LDAvis} from github
(\code{devtools::install_github("cpsievert/LDAvis")}).
}
\examples{
lda <- LDA(ECB_press_conferences_tokens)
lda <- fit(lda, 100)
LDAvis(lda)
}
\seealso{
\code{\link[=plot.sentopicmodel]{plot.sentopicmodel()}}
}
