% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutate_nse.R
\name{mutate_nse}
\alias{mutate_nse}
\title{mutate non-standard evaluation interface.}
\usage{
mutate_nse(.data, ..., mutate_nse_split_terms = TRUE,
  mutate_nse_env = parent.frame())
}
\arguments{
\item{.data}{data.frame}

\item{...}{stringified expressions to mutate by.}

\item{mutate_nse_split_terms}{logical, if TRUE into separate mutates (if FALSE instead, pass all at once to dplyr).}

\item{mutate_nse_env}{environment to work in.}
}
\value{
.data with altered columns.
}
\description{
Mutate a data frame by the mutateTerms.  Accepts arbitrary text as
mutateTerms to allow forms such as "Sepal.Length >= 2 * Sepal.Width".
Terms are vectors or lists of the form "lhs := rhs".
Semantics are: terms are evaluated left to right if mutate_nse_split_terms==TRUE (the default).
}
\examples{


resCol1 <- "Sepal_Long"
ratio <- 2
compCol1 <- "Sepal.Width"


datasets::iris \%.>\%
  mutate_nse(., resCol1 := "Sepal.Length" >= ratio * compCol1,
                "Petal_Short" := "Petal.Length" <= 3.5) \%.>\%
  summary(.)


}
\seealso{
\code{\link{mutate_se}}, \code{\link[dplyr]{mutate}}, \code{\link[dplyr]{mutate_at}}, \code{\link[wrapr]{:=}}
}
