% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_pars.R
\name{simulate_initial_probs}
\alias{simulate_initial_probs}
\alias{simulate_transition_probs}
\alias{simulate_emission_probs}
\title{Simulate Parameters of Hidden Markov Models}
\usage{
simulate_initial_probs(n_states, n_clusters = 1)

simulate_transition_probs(n_states, n_clusters = 1, left_right = FALSE,
  diag_c = 0)

simulate_emission_probs(n_states, n_symbols, n_clusters = 1)
}
\arguments{
\item{n_states}{Number of states in each cluster.}

\item{n_clusters}{Number of clusters.}

\item{left_right}{Constrain the transition probabilities to upper triangular.
Default is \code{FALSE}.}

\item{diag_c}{A constant value to be added to diagonal of transition matrices before scaling.}

\item{n_symbols}{Number of distinct symbols in each channel.}
}
\description{
These are helper functions for quick construction of initial values for various
model building functions.
Mostly useful for global optimization algorithms which do not depend on initial values.
}
\seealso{
\code{\link{build_hmm}}, \code{\link{build_mhmm}},
  \code{\link{build_mm}}, \code{\link{build_mmm}}, and  \code{\link{build_lcm}}
  for constructing different types of models.
}
