% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_mm.R
\name{build_mm}
\alias{build_mm}
\title{Build a Markov Model}
\usage{
build_mm(observations, transition_probs, initial_probs)
}
\arguments{
\item{observations}{TraMineR stslist (see \code{\link[TraMineR]{seqdef}}) containing
the sequences.}

\item{transition_probs}{A matrix of transition probabilities. Transition probabilities should follow the
ordering of the alphabet of observations (\code{alphabet(observations)}, returned as \code{state_names}).}

\item{initial_probs}{A vector of initial state probabilities.}
}
\value{
Object of class \code{hmm} with following elements:
\describe{
   \item{\code{observations}}{State sequence object or a list of such containing the data.}
   \item{\code{transition_probs}}{A matrix of transition probabilities.}
   \item{\code{emission_probs}}{A matrix or a list of matrices of emission probabilities.}
   \item{\code{initial_probs}}{A vector of initial probabilities.}
   \item{\code{state_names}}{Names for hidden states.}
   \item{\code{symbol_names}}{Names for observed states.}
   \item{\code{channel_names}}{Names for channels of sequence data.}
   \item{\code{length_of_sequences}}{(Maximum) length of sequences.}
   \item{\code{n_sequences}}{Number of sequences.}
   \item{\code{n_symbols}}{Number of observed states (in each channel).}
   \item{\code{n_states}}{Number of hidden states.}
   \item{\code{n_channels}}{Number of channels.}
}
}
\description{
Function \code{build_mm} is a shortcut for constructing a Markov model as an restricted case of \code{hmm} object.
}
\examples{

data("mvad", package = "TraMineR")

mvad_alphabet <-
  c("employment", "FE", "HE", "joblessness", "school", "training")
mvad_labels <- c("employment", "further education", "higher education",
  "joblessness", "school", "training")
mvad_scodes <- c("EM", "FE", "HE", "JL", "SC", "TR")
mvad_seq <- seqdef(mvad, 17:86, alphabet = mvad_alphabet,
  states = mvad_scodes, labels = mvad_labels, xtstep = 6)

attr(mvad_seq, "cpal") <- colorpalette[[6]]


init_mm_mvad <- build_mm(observations = mvad_seq,
  transition_probs = simulate_transition_probs(6),
  initial_probs = rep(1/6,6))

mm_mvad <- fit_model(init_mm_mvad)

}
\seealso{
\code{\link{fit_model}} for estimating model parameters.
}

