% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rest-api.r
\name{drill_storage}
\alias{drill_storage}
\alias{drill_mod_storage}
\alias{drill_rm_storage}
\title{Retrieve, modify or update storage plugin names and configurations}
\usage{
drill_storage(drill_con, plugin = NULL, as = c("tbl", "list", "raw"))

drill_mod_storage(drill_con, name, config)

drill_rm_storage(drill_con, name)
}
\arguments{
\item{drill_con}{drill server connection object setup by \code{drill_connection()}}

\item{plugin}{the assigned name in the storage plugin definition.}

\item{as}{one of "\code{tbl}" or "\code{list}" or "\code{raw}". The latter two are useful if you want
modify an existing storage plugin (e.g. add a workspace) via
\code{\link[=drill_mod_storage]{drill_mod_storage()}}.}

\item{name}{name of the storage plugin configuration to create/update/remove}

\item{config}{a raw 1-element character vector containing valid JSON of a
complete storage spec}
}
\description{
Retrieve, modify or remove storage plugins from a Drill instance. If you intend
to modify an existing configuration it is suggested that you use the "\code{list}" or
"\code{raw}" values to the \code{as} parameter to make it easier to modify them.
}
\examples{
\dontrun{
drill_connection() \%>\% drill_storage()

drill_connection() \%>\%
  drill_mod_storage(
    name = "drilldat",
    config = '
{
  "config" : {
    "connection" : "file:///",
    "enabled" : true,
    "formats" : null,
    "type" : "file",
    "workspaces" : {
      "root" : {
        "location" : "/Users/hrbrmstr/drilldat",
        "writable" : true,
        "defaultInputFormat": null
      }
    }
  },
  "name" : "drilldat"
}
')
}
}
\references{
\href{https://drill.apache.org/docs/}{Drill documentation}
}
\seealso{
Other Drill direct REST API Interface: 
\code{\link{drill_active}()},
\code{\link{drill_cancel}()},
\code{\link{drill_connection}()},
\code{\link{drill_functions}()},
\code{\link{drill_metrics}()},
\code{\link{drill_options}()},
\code{\link{drill_opts}()},
\code{\link{drill_profiles}()},
\code{\link{drill_profile}()},
\code{\link{drill_query}()},
\code{\link{drill_settings_reset}()},
\code{\link{drill_set}()},
\code{\link{drill_stats}()},
\code{\link{drill_status}()},
\code{\link{drill_system_reset}()},
\code{\link{drill_threads}()},
\code{\link{drill_version}()}
}
\concept{Drill direct REST API Interface}
