% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/static.R
\name{create_server}
\alias{create_server}
\title{Create a server}
\usage{
create_server(..., handler, ws_open = function(ws) NULL)
}
\arguments{
\item{...}{Arguments to be passed to \code{\link{server_config}()}.}

\item{handler}{A function that takes the HTTP request and returns a response.}

\item{ws_open}{A function to be called back when a WebSocket connection is
established (see \code{httpuv::\link[httpuv]{startServer}()}).}
}
\description{
Create a server with a custom handler to handle the HTTP request.
}
\examples{\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# always return 'Success:' followed by the requested path
s = servr::create_server(handler = function(req) {
    list(status = 200L, body = paste("Success:", req$PATH_INFO))
})
s$url

browseURL(paste0(s$url, "/hello"))
browseURL(paste0(s$url, "/world"))

s$stop_server()
\dontshow{\}) # examplesIf}
}
