% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/global-measures.R
\name{global_moran_perm}
\alias{global_moran_perm}
\title{Global Moran Permutation Test}
\usage{
global_moran_perm(x, nb, wt, alternative = "two.sided", nsim = 499, ...)
}
\arguments{
\item{x}{A numeric vector.}

\item{nb}{a neighbor list object for example as created by \code{st_contiguity()}.}

\item{wt}{a weights list as created by \code{st_weights()}.}

\item{alternative}{default \code{"two.sided"}. Should be one of \code{"greater"}, \code{"less"}, or \code{"two.sided"} to specify the alternative hypothesis.}

\item{nsim}{number of simulations to run.}

\item{...}{additional arguments passed to \code{\link[spdep:moran.mc]{spdep::moran.mc()}}}
}
\value{
an object of classes \code{htest}, and \code{mc.sim}.
}
\description{
Global Moran Permutation Test
}
\examples{
nb <- guerry_nb$nb
wt <- guerry_nb$wt
x <- guerry_nb$crime_pers
moran <- global_moran_perm(x, nb, wt)
moran
}
\seealso{
Other global_moran: 
\code{\link{global_moran}()},
\code{\link{global_moran_bv}()},
\code{\link{global_moran_test}()},
\code{\link{local_moran_bv}()}
}
\concept{global_moran}
