% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sgee.control.R
\name{sgee.control}
\alias{sgee.control}
\title{Auxiliary for Controlling SGEE fitting}
\usage{
sgee.control(maxIt = 200, epsilon = 0.05, stoppingThreshold = NULL)
}
\arguments{
\item{maxIt}{Maximum number of iterations of the stagewise algorithm to be
executed. Default is 200.}

\item{epsilon}{Step size to be used when incrementing coefficient value(s)
in each iteration. Default is 0.05.}

\item{stoppingThreshold}{An integer value that indicates the maximum number
of allowed covariates in the model. Once the algorithm has reached the value
of \code{stoppingThreshold}, the algorithm will stop without completing any
remaining iterations. The number of covariates to be included cannot exceed
the number of observations. The default value is typically
the minimum of the number
of covariates and the number of observations, minus 1 if an intercept is
included.}
}
\value{
A list containing all of the parameter values.
}
\description{
Auxiliary function for \code{sgee} fitting functions. Specifies
parameters used by all \code{sgee} fitting functions in terms
of the path generation; i.e. step size \code{epsilon}, maximum number of
iterations \code{maxIt}, and the threshold for premature stopping
\code{stoppingthreshold}.
}
\author{
Gregory Vaughan
}

