% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surfaceGrid.R
\name{surfaceGrid}
\alias{surfaceGrid}
\title{Create grid of 3D points covering the 'facades' and 'roofs' of obstacles}
\usage{
surfaceGrid(obstacles, obstacles_height_field, res, offset = 0.01)
}
\arguments{
\item{obstacles}{A \code{SpatialPolygonsDataFrame} object specifying the obstacles outline}

\item{obstacles_height_field}{Name of attribute in \code{obstacles} with extrusion height for each feature}

\item{res}{Required grid resolution, in CRS units}

\item{offset}{Offset between grid points and facade (horizontal distance) or between grid points and roof (vertical distance).}
}
\value{
A 3D \code{SpatialPointsDataFrame} layer, including all attributes of the original obstacles each surface point corresponds to, followed by six new attributes:\itemize{
\item{\code{obs_id} Unique consecutive ID for each feature in \code{obstacles}}
\item{\code{type} Either \code{"facade"} or \code{"roof"}}
\item{\code{seg_id} Unique consecutive ID for each facade segment (only for 'facade' points)}
\item{\code{xy_id} Unique consecutive ID for each ground location (only for 'facade' points)}
\item{\code{facade_az} The azimuth of the corresponding facade, in decimal degrees (only for 'facade' points)}
}
}
\description{
The function creates a grid of 3D points covering the given obstacles at specified resolution. Such a grid can later on be used to quantify the shaded / non-shaded proportion of the obstacles surface area.
}
\note{
The reason for introducing an offset is to avoid ambiguity as for whether the grid points are "inside" or "outside" of the obstacle. With an offset all grid points are "outside" of the building and thus not intersecting it. \code{offset} should be given in CRS units; default is 0.01.
}
\examples{
grid = surfaceGrid(
  obstacles = build,
  obstacles_height_field = "BLDG_HT",
  res = 2
)
plot(grid)
plot(grid, pch = 1, lwd = 0.1, col = "black", add = TRUE)

# When 'res/2' is larger then height, facade will be left unsampled
build_small = build
build_small$BLDG_HT = 1
grid = surfaceGrid(
  obstacles = build_small,
  obstacles_height_field = "BLDG_HT",
  res = 2
)
plot(grid)
plot(grid, pch = 1, lwd = 0.1, col = "black", add = TRUE)
table(grid$type)

grid = surfaceGrid(
  obstacles = build_small,
  obstacles_height_field = "BLDG_HT",
  res = 2.00001  # res/2 > h
)
plot(grid)
plot(grid, pch = 1, lwd = 0.1, col = "black", add = TRUE)
table(grid$type)

# When input already contains 'obs_id', 'type', 'seg_id', 'xy_id', 'facade_az' or 'ZZZ'
build2 = build
build2$ZZZ = 1
grid = surfaceGrid(
  obstacles = build2,
  obstacles_height_field = "BLDG_HT",
  res = 2
)

}
\seealso{
Function \code{\link{plotGrid}} to visualize grid.
}
