% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/shapeR.R
\name{plotFourier}
\alias{plotFourier}
\title{Mean and standard deviation of the Fourier coefficients}
\usage{
plotFourier(object, coef.index=NULL,class.name=NULL,useStdcoef=FALSE, ...)
}
\arguments{
\item{object}{\code{\linkS4class{shapeR}} object}

\item{coef.index}{An index vector for which fourier coefficents to be shown. Default is \code{NULL} and all coefficients are shown.}

\item{class.name}{Column name in master list for partitioning the data into groups and showing the ratio of variance among to the sum of variance among and variance within.}

\item{useStdcoef}{Boolean saying if to use the standardized coefficients or not}

\item{...}{Additional parameters to be passed to 'plot'}
}
\description{
The mean and standard deviation of the Fourier coefficients
}
\examples{
data(shape)
shape = stdCoefs(shape,classes="pop","length_cm")
plotFourier(shape,class.name= "pop",useStdcoef=TRUE)
}
\author{
Lisa Anne Libungan
}

