% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.R
\name{CheckDataRegression}
\alias{CheckDataRegression}
\title{Checking input data (regression model)}
\usage{
CheckDataRegression(xdata, ydata = NULL, family = "gaussian", verbose = TRUE)
}
\arguments{
\item{xdata}{matrix of predictors with observations as rows and variables as
columns.}

\item{ydata}{optional vector or matrix of outcome(s). If \code{family} is set
to \code{"binomial"} or \code{"multinomial"}, \code{ydata} can be a vector
with character/numeric values or a factor.}

\item{family}{type of regression model. This argument is defined as in
\code{\link[glmnet]{glmnet}}. Possible values include \code{"gaussian"}
(linear regression), \code{"binomial"} (logistic regression),
\code{"multinomial"} (multinomial regression), and \code{"cox"} (survival
analysis).}

\item{verbose}{logical indicating if a loading bar and messages should be
printed.}
}
\description{
Checks if input data formats are appropriate. For inappropriate inputs, this
function (i) fixes the data format, or (ii) stops the run and generates an
error message.
}
\keyword{internal}
