% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PFER.R
\name{FDP}
\alias{FDP}
\title{False Discovery Proportion}
\usage{
FDP(selprop, PFER, pi)
}
\arguments{
\item{selprop}{matrix or vector of selection proportions.}

\item{PFER}{Per Family Error Rate.}

\item{pi}{threshold in selection proportions.}
}
\value{
The estimated upper-bound in FDP.
}
\description{
Computes the False Discovery Proportion (upper-bound) as a ratio of the PFER
(upper-bound) over the number of stably selected features. In stability
selection, the FDP corresponds to the expected proportion of stably selected
features that are not relevant to the outcome (i.e. proportion of False
Positives among stably selected features).
}
\examples{
# Simulating set of selection proportions
selprop <- round(runif(n = 20), digits = 2)

# Computing the FDP with a threshold of 0.8
fdp <- FDP(PFER = 3, selprop = selprop, pi = 0.8)
}
\seealso{
Other stability metric functions: 
\code{\link{ConsensusScore}()},
\code{\link{PFER}()},
\code{\link{StabilityMetrics}()},
\code{\link{StabilityScore}()}
}
\concept{stability metric functions}
