% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{SerialClustering}
\alias{SerialClustering}
\title{Consensus clustering (internal)}
\usage{
SerialClustering(
  xdata,
  nc,
  eps,
  Lambda,
  K = 100,
  tau = 0.5,
  seed = 1,
  n_cat = 3,
  implementation = HierarchicalClustering,
  scale = TRUE,
  linkage = "complete",
  row = TRUE,
  output_data = FALSE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{xdata}{data matrix with observations as rows and variables as columns.}

\item{nc}{matrix of parameters controlling the number of clusters in the
underlying algorithm specified in \code{implementation}. If \code{nc} is
not provided, it is set to \code{seq(1, tau*nrow(xdata))}.}

\item{eps}{radius in density-based clustering, see
\code{\link[dbscan]{dbscan}}. Only used if
\code{implementation=DBSCANClustering}.}

\item{Lambda}{vector of penalty parameters for weighted distance calculation.
Only used if \code{implementation=HierarchicalClustering},
\code{implementation=PAMClustering}, or
\code{implementation=DBSCANClustering}.}

\item{K}{number of resampling iterations.}

\item{tau}{subsample size.}

\item{seed}{value of the seed to initialise the random number generator and
ensure reproducibility of the results (see \code{\link[base]{set.seed}}).}

\item{n_cat}{computation options for the stability score. Default is
\code{NULL} to use the score based on a z test. Other possible values are 2
or 3 to use the score based on the negative log-likelihood.}

\item{implementation}{function to use for clustering. Possible functions
include \code{\link{HierarchicalClustering}} (hierarchical clustering),
\code{\link{PAMClustering}} (Partitioning Around Medoids),
\code{\link{KMeansClustering}} (k-means) and \code{\link{GMMClustering}}
(Gaussian Mixture Models). Alternatively, a user-defined function taking
\code{xdata} and \code{Lambda} as arguments and returning a binary and
symmetric matrix for which diagonal elements are equal to zero can be used.}

\item{scale}{logical indicating if the data should be scaled to ensure that
all variables contribute equally to the clustering of the observations.}

\item{linkage}{character string indicating the type of linkage used in
hierarchical clustering to define the stable clusters. Possible values
include \code{"complete"}, \code{"single"} and \code{"average"} (see
argument \code{"method"} in \code{\link[stats]{hclust}} for a full list).
Only used if \code{implementation=HierarchicalClustering}.}

\item{row}{logical indicating if rows (if \code{row=TRUE}) or columns (if
\code{row=FALSE}) contain the items to cluster.}

\item{output_data}{logical indicating if the input datasets \code{xdata} and
\code{ydata} should be included in the output.}

\item{verbose}{logical indicating if a loading bar and messages should be
printed.}

\item{...}{additional parameters passed to the functions provided in
\code{implementation} or \code{resampling}.}
}
\value{
A list with: \item{Sc}{a matrix
  of the best stability scores for different (sets of) parameters controlling
  the number of clusters and penalisation of attribute weights.} \item{nc}{a
  matrix of numbers of clusters.} \item{Lambda}{a matrix of regularisation
  parameters for attribute weights.} \item{Q}{a matrix of the average number
  of selected attributes by the underlying algorithm with different
  regularisation parameters.} \item{coprop}{an array of consensus matrices.
  Rows and columns correspond to items. Indices along the third dimension
  correspond to different parameters controlling the number of clusters and
  penalisation of attribute weights.} \item{selprop}{an array of selection
  proportions. Columns correspond to attributes. Rows correspond to different
  parameters controlling the number of clusters and penalisation of attribute
  weights.} \item{method}{a list with \code{type="clustering"} and values
  used for arguments \code{implementation}, \code{linkage}, and
  \code{resampling}.} \item{params}{a list with values used for arguments
  \code{K}, \code{tau}, \code{pk}, \code{n} (number of observations in
  \code{xdata}), and \code{seed}.} The rows of \code{Sc}, \code{nc},
  \code{Lambda}, \code{Q}, \code{selprop} and indices along the third
  dimension of \code{coprop} are ordered in the same way and correspond to
  parameter values stored in \code{nc} and \code{Lambda}.
}
\description{
Performs consensus (weighted) clustering. The underlying algorithm (e.g.
hierarchical clustering) is run with different number of clusters \code{nc}.
In consensus weighed clustering, weighted distances are calculated using the
\code{\link[rCOSA]{cosa2}} algorithm with different penalty parameters
\code{Lambda}. The hyper-parameters are calibrated by maximisation of the
consensus score. This function uses a serial implementation and requires the grids of
hyper-parameters as input (for internal use only).
}
\keyword{internal}
