% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLSS2LL.R
\name{LL2PLSS}
\alias{LL2PLSS}
\alias{plssMeridians}
\title{LL2PLSS}
\usage{
LL2PLSS(x, y, returnlevel = "I")
}
\arguments{
\item{x}{longitude coordinates}

\item{y}{latitude coordinates}

\item{returnlevel}{'S' for "Section" or 'I' for "Intersection" (subsections)}
}
\value{
\code{list} of of PLSS codes and coordinates.
}
\description{
Uses latitude and longitude coordinates to return the PLSS section geometry from the BLM PLSS web service.
}
\details{
This function takes xy coordinates and returns the PLSS section geometry to the quarter-quarter section. \code{returnlevel} options are defaulted to 'I' which returns smallest intersected sectional aliquot geometry, 'S' will return the section geometry of the coordinates. See https://gis.blm.gov/arcgis/rest/services/Cadastral/BLM_Natl_PLSS_CadNSDI/MapServer for details.
}
\note{
This function requires the following packages: \code{httr}, \code{jsonlite}, and \code{sp}.
}
\seealso{
\code{\link{PLSS2LL}}, \code{\link{formatPLSS}}
}
\author{
D.E. Beaudette, Jay Skovlin, A.G. Brown
}
