% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WB-summary.R
\name{monthlyWB_summary}
\alias{monthlyWB_summary}
\title{Water Balance Summaries}
\usage{
monthlyWB_summary(w, AWC = NULL, PWP = NULL, FC = NULL, SAT = NULL)
}
\arguments{
\item{w}{used for for \code{monthlyWB_summary()}: a data.frame, such as result of \code{monthlyWB()};}

\item{AWC}{numeric, optional plant-available water storage (mm)}

\item{PWP}{numeric, optional permanent wilting point (volumetric water content)}

\item{FC}{numeric, optional field capacity (volumetric water content)}

\item{SAT}{numeric, optional saturation capacity (volumetric water content)}
}
\value{
\code{monthlyWB_summary()}: a \code{data.frame} containing:
\itemize{
\item cumulative (\code{dry}, \code{moist}, \code{wet}) days
\item consecutive (\code{dry_con}, \code{moist_con}, \code{wet_con}) days
\item total deficit (\code{total_deficit}) in mm
\item total surplus (\code{total_surplus}) in mm
\item total actual evapotranspiration (\code{total_AET}) in mm
\item annual actual evapotranspiration to potential evapotranspiration ratio (\code{annual_AET_PET_ratio})
}
}
\description{
A summary of a monthly water balance, including estimates of total and consecutive "dry", "moist", "wet" conditions, total surplus, deficit, and AET, and annual AET/PET ratio.
}
\note{
Work in progress: AWC, PWP, FC, and SAT arguments are currently ignored!
}
