% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Baseline.R
\name{editBaseline}
\alias{editBaseline}
\title{Edit the Baseline object}
\usage{
editBaseline(baseline, field, value)
}
\arguments{
\item{baseline}{\code{Baseline} object to be edited.}

\item{field}{name of the field in the \code{Baseline} object to be edited.}

\item{value}{value to set the \code{field}.}
}
\value{
A \code{Baseline} object with the field of choice updated.
}
\description{
\code{editBaseline} edits a field in a \code{Baseline} object.
}
\examples{
\donttest{
# Subset example data
data(ExampleDb, package="alakazam")
db <- subset(ExampleDb, ISOTYPE == "IgG" & SAMPLE == "+7d")

# Make Baseline object
baseline <- calcBaseline(db, 
                         sequenceColumn="SEQUENCE_IMGT",
                         germlineColumn="GERMLINE_IMGT_D_MASK", 
                         testStatistic="focused",
                         regionDefinition=IMGT_V,
                         targetingModel=HH_S5F,
                         nproc=1)
                         
# Edit the field "description"
baseline <- editBaseline(baseline, field="description", 
                         value="+7d IgG")
}

}
\seealso{
See \link{Baseline} for the input and return object.
}
