% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/components.R
\name{Popover}
\alias{Popover}
\title{Popover}
\usage{
Popover(...)
}
\arguments{
\item{...}{Component props and children. See the official Blueprint docs for details.}
}
\value{
Object with \code{shiny.tag} class suitable for use in the UI of a Shiny app.
}
\description{
Documentation: \url{https://blueprintjs.com/docs/#core/components/popover}
}
\examples{
library(shiny.blueprint)
library(shiny)

ui <- function(id) {
  ns <- NS(id)
  reactOutput(ns("ui"))
}

server <- function(id) {
  moduleServer(id, function(input, output, session) {
    ns <- session$ns

    isOpen <- reactiveVal(FALSE)
    observeEvent(input$hello, isOpen(TRUE))
    observeEvent(input$dismiss, isOpen(FALSE))

    output$ui <- renderReact({
      Popover(
        isOpen = isOpen(),
        target = Button.shinyInput(ns("hello"), "Say Hello", intent = "primary"),
        usePortal = FALSE,
        content = tags$div(
          style = "padding: 1em",
          H5("Hello!"),
          tags$p("Please read this message."),
          Button.shinyInput(ns("dismiss"), "Dismiss")
        )
      )
    })
  })
}

if (interactive()) shinyApp(ui("app"), function(input, output) server("app"))
}
