% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/components.R
\name{TextArea}
\alias{TextArea}
\title{Text area}
\usage{
TextArea(...)
}
\arguments{
\item{...}{Component props and children. See the official Blueprint docs for details.}
}
\value{
Object with \code{shiny.tag} class suitable for use in the UI of a Shiny app.
}
\description{
Documentation: \url{https://blueprintjs.com/docs/#core/components/text-inputs.text-area}
}
\examples{
library(shiny.blueprint)
library(shiny)

setInput <- function(inputId, accessor = NULL) {
  JS(paste0("x => Shiny.setInputValue('", inputId, "', x", accessor, ")"))
}

ui <- function(id) {
  ns <- NS(id)
  tagList(
    H4("Uncontrolled"),
    TextArea(
      growVertically = TRUE,
      onChange = setInput(ns("uncontrolledTextarea"), ".target.value"),
      large = TRUE,
      intent = "primary"
    ),
    textOutput(ns("uncontrolledTextareaOutput")),
    H4("Controlled"),
    TextArea.shinyInput(
      inputId = ns("controlledTextarea"),
      growVertically = TRUE,
      large = TRUE,
      intent = "primary"
    ),
    textOutput(ns("controlledTextareaOutput"))
  )
}

server <- function(id) {
  moduleServer(id, function(input, output, session) {
    output$uncontrolledTextareaOutput <- renderText(input$uncontrolledTextarea)
    output$controlledTextareaOutput <- renderText(input$controlledTextarea)
  })
}

if (interactive()) shinyApp(ui("app"), function(input, output) server("app"))
}
