% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/update-input.R
\name{updateSelectInput}
\alias{updateSelectInput}
\alias{updateSelectizeInput}
\title{Change the value of a select input on the client}
\usage{
updateSelectInput(session, inputId, label = NULL, choices = NULL,
  selected = NULL)

updateSelectizeInput(session, inputId, label = NULL, choices = NULL,
  selected = NULL, options = list(), server = FALSE)
}
\arguments{
\item{session}{The \code{session} object passed to function given to
\code{shinyServer}.}

\item{inputId}{The id of the input object.}

\item{label}{The label to set for the input object.}

\item{choices}{List of values to select from. If elements of the list are
named then that name rather than the value is displayed to the user.}

\item{selected}{The initially selected value (or multiple values if
\code{multiple = TRUE}). If not specified then defaults to the first value
for single-select lists and no values for multiple select lists.}

\item{options}{A list of options. See the documentation of \pkg{selectize.js}
for possible options (character option values inside \code{\link{I}()} will
be treated as literal JavaScript code; see \code{\link{renderDataTable}()}
for details).}

\item{server}{whether to store \code{choices} on the server side, and load
the select options dynamically on searching, instead of writing all
\code{choices} into the page at once (i.e., only use the client-side
version of \pkg{selectize.js})}
}
\description{
Change the value of a select input on the client
}
\details{
The input updater functions send a message to the client, telling it to
change the settings of an input object. The messages are collected and sent
after all the observers (including outputs) have finished running.

The syntax of these functions is similar to the functions that created the
inputs in the first place. For example, \code{\link{numericInput}()} and
\code{updateNumericInput()} take a similar set of arguments.

Any arguments with NULL values will be ignored; they will not result in any
changes to the input object on the client.
}
\examples{
\dontrun{
shinyServer(function(input, output, session) {

  observe({
    # We'll use the input$controller variable multiple times, so save it as x
    # for convenience.
    x <- input$controller

    # Create a list of new options, where the name of the items is something
    # like 'option label x 1', and the values are 'option-x-1'.
    s_options <- list()
    s_options[[sprintf("option label \%d 1", x)]] <- sprintf("option-\%d-1", x)
    s_options[[sprintf("option label \%d 2", x)]] <- sprintf("option-\%d-2", x)

    # Change values for input$inSelect
    updateSelectInput(session, "inSelect", choices = s_options)

    # Can also set the label and select an item (or more than one if it's a
    # multi-select)
    updateSelectInput(session, "inSelect2",
      label = paste("Select label", x),
      choices = s_options,
      selected = sprintf("option-\%d-2", x)
    )
  })
})
}
}
\seealso{
\code{\link{selectInput}}
}

