% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7-update-inputs.R
\name{updateF7Text}
\alias{updateF7Text}
\title{Change the value of a text input on the client}
\usage{
updateF7Text(session, inputId, label = NULL, value = NULL, placeholder = NULL)
}
\arguments{
\item{session}{The session object passed to function given to the server.}

\item{inputId}{The id of the input object.}

\item{label}{The label to set for the input object.}

\item{value}{The value to set for the input object.}

\item{placeholder}{The placeholder to set for the input object.}
}
\description{
Change the value of a text input on the client
}
\examples{
if (interactive()) {
 library(shiny)
 library(shinyMobile)

 ui <- f7Page(
   f7SingleLayout(
    navbar = f7Navbar(title = "updateF7Text"),
    f7Fab("trigger", "Click me"),
    f7Text(
     inputId = "text",
     label = "Caption",
     value = "Some text",
     placeholder = "Your text here"
    ),
    verbatimTextOutput("value")
   )
 )

 server <- function(input, output, session) {
   output$value <- renderPrint(input$text)
   observeEvent(input$trigger, {
     updateF7Text(session, "text", value = "Updated Text")
   })
 }
shinyApp(ui, server)
}
}
