% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input-noUiSlider.R
\name{noUiSliderInput}
\alias{noUiSliderInput}
\title{Numeric range slider}
\usage{
noUiSliderInput(
  inputId,
  label = NULL,
  min,
  max,
  value,
  step = NULL,
  tooltips = TRUE,
  connect = TRUE,
  padding = 0,
  margin = NULL,
  limit = NULL,
  orientation = c("horizontal", "vertical"),
  direction = c("ltr", "rtl"),
  behaviour = "tap",
  range = NULL,
  pips = NULL,
  format = wNumbFormat(),
  update_on = c("end", "change"),
  color = NULL,
  inline = FALSE,
  width = NULL,
  height = NULL
)
}
\arguments{
\item{inputId}{The \code{input} slot that will be used to access the value.}

\item{label}{Display label for the control, or NULL for no label.}

\item{min}{Minimal value that can be selected.}

\item{max}{Maximal value that can be selected.}

\item{value}{The initial value of the slider. as many cursors will be created as values provided.}

\item{step}{numeric, by default, the slider slides fluently.
In order to make the handles jump between intervals, you can use
the step option.}

\item{tooltips}{logical, display slider's value in a tooltip above slider.}

\item{connect}{logical, vector of length \code{value} + 1, color slider between handle(s).}

\item{padding}{numeric, padding limits how close to the slider edges handles can be.}

\item{margin}{numeric, when using two handles, the minimum distance between
the handles can be set using the margin option.}

\item{limit}{numeric, the limit option is the opposite of the \code{margin} option,
limiting the maximum distance between two handles.}

\item{orientation}{The orientation setting can be used to set the
slider to \code{"vertical"} or \code{"horizontal"}.}

\item{direction}{\code{"ltr"} or \code{"rtl"}, By default the sliders are top-to-bottom and left-to-right,
but you can change this using the direction option,
which decides where the upper side of the slider is.}

\item{behaviour}{Option to handle user interaction, a value or several between
\code{"drag"}, \code{"tap"}, \code{"fixed"}, \code{"snap"} or \code{"none"}.
See \url{https://refreshless.com/nouislider/behaviour-option/} for more examples.}

\item{range}{list, can be used to define non-linear sliders.}

\item{pips}{list, used to generate points along the slider.}

\item{format}{numbers format, see \code{\link{wNumbFormat}}.}

\item{update_on}{When to send value to server: \code{"end"} (when slider is released) or \code{"update"} (each time value changes).}

\item{color}{color in Hex format for the slider.}

\item{inline}{If \code{TRUE}, it's possible to position sliders side-by-side.}

\item{width}{The width of the input, e.g. \verb{400px}, or \verb{100\%}.}

\item{height}{The height of the input, e.g. \verb{400px}, or \verb{100\%}.}
}
\value{
a ui definition
}
\description{
A minimal numeric range slider with a lot of features.
}
\note{
See \code{\link[=updateNoUiSliderInput]{updateNoUiSliderInput()}} for updating slider value server-side.
And \code{\link[=demoNoUiSlider]{demoNoUiSlider()}} for examples.
}
\examples{
library(shiny)
library(shinyWidgets)

ui <- fluidPage(
  tags$h2("noUiSliderInput example"),

  noUiSliderInput(
    inputId = "noui1",
    min = 0, max = 100,
    value = 20
  ),
  verbatimTextOutput(outputId = "res1"),

  tags$br(),

  noUiSliderInput(
    inputId = "noui2", label = "Slider vertical:",
    min = 0, max = 1000, step = 50,
    value = c(100, 400), margin = 100,
    orientation = "vertical",
    width = "100px", height = "300px"
  ),
  verbatimTextOutput(outputId = "res2")
)

server <- function(input, output, session) {

  output$res1 <- renderPrint(input$noui1)
  output$res2 <- renderPrint(input$noui2)

}

if (interactive())
  shinyApp(ui, server)
}
