% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extend_shinysurveys.R
\name{extendInputType}
\alias{extendInputType}
\title{Add Custom Input Types for a Survey}
\usage{
extendInputType(input_type, extension)
}
\arguments{
\item{input_type}{A string of the input type supplied in the data frame of questions.}

\item{extension}{A shiny input type not natively supported by {shinysurveys}. See the examples section for more information.}
}
\value{
NA; used to register custom input types for use with a shiny survey.
}
\description{
Add Custom Input Types for a Survey
}
\examples{

# Register a slider input to {shinysurveys} with a custom minimum and maximum value.

extendInputType("slider", {
  shiny::sliderInput(
    inputId = surveyID(),
    label = surveyLabel(),
    min = 1,
    max = 10,
    value = 5
    )
  })

# Define a question as normal with the `input_type` set to the custom slider type defined above.
slider_question <- data.frame(question = "On a scale from 1-10,
how much do you love sushi?",
option = NA,
input_type = "slider",
input_id = "sushi_scale",
dependence = NA,
dependence_value = NA,
required = TRUE)

# Watch it in action
if (interactive()) {
ui <- fluidPage(
  surveyOutput(df = slider_question, "Sushi Scale Example")
)

server <- function(input, output, session) {
  renderSurvey()
}

shinyApp(ui, server)

}



# Register a date input to {shinysurveys},
# limiting possible dates to a twenty-day period.

extendInputType("date", {
  shiny::dateInput(
    inputId = surveyID(),
    value = Sys.Date(),
    label = surveyLabel(),
    min = Sys.Date()-10,
    max = Sys.Date()+10
  )
})

# Define a question as normal with the `input_type` set to
# the custom date type defined above.

date_question <- data.frame(question = "When do you graduate?",
option = NA,
input_type = "date",
input_id = "grad_date",
dependence = NA,
dependence_value = NA,
required = FALSE)

# Watch it in action
if (interactive()) {
ui <- fluidPage(
  surveyOutput(df = date_question, "Date Input Extension Example")
)

server <- function(input, output, session) {
  renderSurvey()
}

shinyApp(ui, server)
}


# Combine both custom input types:

if (interactive()) {
ui <- fluidPage(
  surveyOutput(df = rbind(slider_question, date_question),
  "Date & Slider Input Extension Example")
)

server <- function(input, output, session) {
  renderSurvey()
}

shinyApp(ui, server)
}


}
\seealso{
\code{\link{surveyID}}

\code{\link{surveyLabel}}
}
