% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-radar-gun.R
\name{model_radar_gun}
\alias{model_radar_gun}
\title{Model Using Instantaneous Velocity or Radar Gun}
\usage{
model_radar_gun(
  time,
  velocity,
  weights = 1,
  CV = NULL,
  use_observed_MSS = FALSE,
  control = minpack.lm::nls.lm.control(maxiter = 1000),
  na.rm = FALSE,
  ...
)
}
\arguments{
\item{time}{Numeric vector}

\item{velocity}{Numeric vector}

\item{weights}{Numeric vector. Default is 1}

\item{CV}{Should cross-validation be used to estimate model fit? Default is \code{NULL}. Otherwise use integer
indicating number of folds. See Example for more information}

\item{use_observed_MSS}{Should \code{MSS} be estimated from the observed \code{velocity}? Default is \code{FALSE}}

\item{control}{Control object forwarded to \code{\link[minpack.lm]{nlsLM}}. Default is \code{minpack.lm::nls.lm.control(maxiter = 1000)}}

\item{na.rm}{Logical. Default is FALSE}

\item{...}{Forwarded to \code{\link[minpack.lm]{nlsLM}} function}
}
\value{
List object with the following elements:
    \describe{
        \item{parameters}{List with the following estimated parameters:
            \code{MSS}, \code{TAU}, \code{MAC}, \code{PMAX}, and \code{TC}}
        \item{model_fit}{List with the following components:
            \code{RSE}, \code{R_squared}, \code{minErr}, \code{maxErr}, and \code{RMSE}}
        \item{model}{Model returned by the \code{\link[minpack.lm]{nlsLM}} function}
        \item{data}{Data frame used to estimate the sprint parameters, consisting of \code{time},
           \code{velocity}, \code{weights}, and \code{pred_velocity} columns}
        }
}
\description{
This function models the sprint instantaneous velocity using mono-exponential equation that estimates
    maximum sprinting speed (\code{MSS}) and relative acceleration (\code{TAU}). \code{velocity} is used as target or outcome
    variable, and \code{time} as predictor.
}
\examples{
instant_velocity <- data.frame(
  time = c(0, 1, 2, 3, 4, 5, 6),
  velocity = c(0.00, 4.99, 6.43, 6.84, 6.95, 6.99, 7.00)
)

sprint_model <- with(
  instant_velocity,
  model_radar_gun(time, velocity)
)

print(sprint_model)
coef(sprint_model)
plot(sprint_model)
}
\references{
Samozino P. 2018. A Simple Method for Measuring Force, Velocity and Power Capabilities and Mechanical
        Effectiveness During Sprint Running. In: Morin J-B, Samozino P eds. Biomechanics of Training and Testing.
       Cham: Springer International Publishing, 237–267. DOI: 10.1007/978-3-319-05633-3_11.
}
