targetDef <- structure(list(ISSF_10mAR = structure(list(name = "ISSF 10m Air Rifle", 
    unitTarget = "mm", nRings = 10, maxVal = 10, convert = structure(list(
        ringD10 = 0.5, ringD10i = 0.5, ringW = 2.5), .Names = c("ringD10", 
    "ringD10i", "ringW")), cols = c("black", "black", "black", 
    "black", "black", "black", "black", "black", "lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2"), colsTxt = c("lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", "black", 
    "black", "black")), .Names = c("name", "unitTarget", "nRings", 
"maxVal", "convert", "cols", "colsTxt")), ISSF_10mAP = structure(list(
    name = "ISSF 10m Air Pistol", unitTarget = "mm", nRings = 10, 
    maxVal = 10, convert = structure(list(ringD10 = 11.5, ringD10i = 5, 
        ringW = 8), .Names = c("ringD10", "ringD10i", "ringW"
    )), cols = c("black", "black", "black", "black", "black", 
    "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2"), colsTxt = c("lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", 
    "black", "black", "black", "black", "black", "black")), .Names = c("name", 
"unitTarget", "nRings", "maxVal", "convert", "cols", "colsTxt"
)), ISSF_25mPP = structure(list(name = "25m Precision Pistol, 50m Pistol", 
    unitTarget = "mm", nRings = 10, maxVal = 10, convert = structure(list(
        ringD10 = 50, ringD10i = 25, ringW = 25), .Names = c("ringD10", 
    "ringD10i", "ringW")), cols = c("black", "black", "black", 
    "black", "black", "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2", "lemonchiffon2"), colsTxt = c("lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", 
    "black", "black", "black", "black", "black", "black")), .Names = c("name", 
"unitTarget", "nRings", "maxVal", "convert", "cols", "colsTxt"
)), ISSF_25mRFP = structure(list(name = "25m Rapid Fire Pistol", 
    unitTarget = "mm", nRings = 6, maxVal = 10, convert = structure(list(
        ringD10 = 100, ringD10i = 50, ringW = 40, extra = 5), .Names = c("ringD10", 
    "ringD10i", "ringW", "extra")), cols = c("black", "black", 
    "black", "black", "black", "black", "black"), colsTxt = c("lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2"), draw = drawTarget_ISSF25mRF), .Names = c("name", 
"unitTarget", "nRings", "maxVal", "convert", "cols", "colsTxt", 
"draw")), ISSF_50m = structure(list(name = "ISSF 50m Rifle", 
    unitTarget = "mm", nRings = 10, maxVal = 10, convert = structure(list(
        ringD10 = 10.4, ringD10i = 5, ringW = 8, extra = 56.2), .Names = c("ringD10", 
    "ringD10i", "ringW", "extra")), cols = c("black", "black", 
    "black", "black", "black", "black", "black", "black", "lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2"), colsTxt = c("lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", "black", 
    "black", "black"), draw = drawTarget_ISSF50m), .Names = c("name", 
"unitTarget", "nRings", "maxVal", "convert", "cols", "colsTxt", 
"draw")), ISSF_300m = structure(list(name = "ISSF 300m Rifle", 
    unitTarget = "mm", nRings = 10, maxVal = 10, convert = structure(list(
        ringD10 = 100, ringD10i = 50, ringW = 50), .Names = c("ringD10", 
    "ringD10i", "ringW")), cols = c("black", "black", "black", 
    "black", "black", "black", "black", "lemonchiffon2", "lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2"), colsTxt = c("lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2", "black", "black", "black", 
    "black"), txtRot = 45, draw = drawTarget_ISSF300m), .Names = c("name", 
"unitTarget", "nRings", "maxVal", "convert", "cols", "colsTxt", 
"txtRot", "draw")), ISSF_50ftPP = structure(list(name = "25m and 50m Precision Pistol target adapted to 50ft", 
    unitTarget = "mm", nRings = 10, maxVal = 10, convert = structure(list(
        ringD10 = 11.31, ringD10i = 3.69, ringW = 7.62), .Names = c("ringD10", 
    "ringD10i", "ringW")), cols = c("black", "black", "black", 
    "black", "black", "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2", "lemonchiffon2"), colsTxt = c("lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", 
    "black", "black", "black", "black", "black", "black")), .Names = c("name", 
"unitTarget", "nRings", "maxVal", "convert", "cols", "colsTxt"
)), ISSF_50ftSP = structure(list(name = "25m and 50m Precision Pistol target adapted to 50ft Sport Pistol", 
    unitTarget = "mm", nRings = 10, maxVal = 10, convert = structure(list(
        ringD10 = 28.27, ringD10i = 13.03, ringW = 15.24), .Names = c("ringD10", 
    "ringD10i", "ringW")), cols = c("black", "black", "black", 
    "black", "black", "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2", "lemonchiffon2"), colsTxt = c("lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", 
    "black", "black", "black", "black", "black", "black")), .Names = c("name", 
"unitTarget", "nRings", "maxVal", "convert", "cols", "colsTxt"
)), ISSF_25ydPP = structure(list(name = "25m and 50m Precision Pistol target adapted to 25yd", 
    unitTarget = "mm", nRings = 10, maxVal = 10, convert = structure(list(
        ringD10 = 19.79, ringD10i = 8.36, ringW = 11.43), .Names = c("ringD10", 
    "ringD10i", "ringW")), cols = c("black", "black", "black", 
    "black", "black", "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2", "lemonchiffon2"), colsTxt = c("lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", 
    "black", "black", "black", "black", "black", "black")), .Names = c("name", 
"unitTarget", "nRings", "maxVal", "convert", "cols", "colsTxt"
)), ISSF_50ydPP = structure(list(name = "25m and 50m Precision Pistol target adapted to 50yd", 
    unitTarget = "mm", nRings = 10, maxVal = 10, convert = structure(list(
        ringD10 = 45.24, ringD10i = 22.38, ringW = 22.86), .Names = c("ringD10", 
    "ringD10i", "ringW")), cols = c("black", "black", "black", 
    "black", "black", "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2", "lemonchiffon2"), colsTxt = c("lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", 
    "black", "black", "black", "black", "black", "black")), .Names = c("name", 
"unitTarget", "nRings", "maxVal", "convert", "cols", "colsTxt"
)), ISSF_25ydRFP = structure(list(name = "25m Rapid Fire Pistol target adapted to 25yd", 
    unitTarget = "mm", nRings = 6, maxVal = 10, convert = structure(list(
        ringD10 = 90.96, ringD10i = 45.25, ringW = 36.575, extra = 5), .Names = c("ringD10", 
    "ringD10i", "ringW", "extra")), cols = c("black", "black", 
    "black", "black", "black", "black", "black"), colsTxt = c("lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2"), draw = drawTarget_ISSF25mRF), .Names = c("name", 
"unitTarget", "nRings", "maxVal", "convert", "cols", "colsTxt", 
"draw")), ISSF_50ftRFP = structure(list(name = "25m Rapid Fire Pistol target adapted to 50ft", 
    unitTarget = "mm", nRings = 6, maxVal = 10, convert = structure(list(
        ringD10 = 58.75, ringD10i = 28.27, ringW = 24.385, extra = 5), .Names = c("ringD10", 
    "ringD10i", "ringW", "extra")), cols = c("black", "black", 
    "black", "black", "black", "black", "black"), colsTxt = c("lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2"), draw = drawTarget_ISSF25mRF), .Names = c("name", 
"unitTarget", "nRings", "maxVal", "convert", "cols", "colsTxt", 
"draw")), ISSF_50ft = structure(list(name = "ISSF 50m Rifle target adapted to 50ft", 
    unitTarget = "mm", nRings = 8, maxVal = 10, convert = structure(list(
        ringD10 = 0.76, ringD10i = 0.76, ringW = 2.44, extra = 16.69), .Names = c("ringD10", 
    "ringD10i", "ringW", "extra")), cols = c("lemonchiffon2", 
    "black", "black", "black", "black", "black", "black", "black", 
    "black"), colsTxt = c("black", "lemonchiffon2", "lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2")), .Names = c("name", "unitTarget", 
"nRings", "maxVal", "convert", "cols", "colsTxt")), ISSF_50yd = structure(list(
    name = "ISSF 50m Rifle target adapted to 50yd", unitTarget = "mm", 
    nRings = 10, maxVal = 10, convert = structure(list(ringD10 = 9.03, 
        ringD10i = 4.09, ringW = 7.315, extra = 51.39), .Names = c("ringD10", 
    "ringD10i", "ringW", "extra")), cols = c("black", "black", 
    "black", "black", "black", "black", "black", "black", "lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2"), colsTxt = c("lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", "black", 
    "black", "black"), draw = drawTarget_ISSF50m), .Names = c("name", 
"unitTarget", "nRings", "maxVal", "convert", "cols", "colsTxt", 
"draw")), ISSF_100yd = structure(list(name = "ISSF 300m Rifle target adapted to 100yd", 
    unitTarget = "mm", nRings = 10, maxVal = 10, convert = structure(list(
        ringD10 = 24.88, ringD10i = 9.64, ringW = 15.24), .Names = c("ringD10", 
    "ringD10i", "ringW")), cols = c("black", "black", "black", 
    "black", "black", "black", "black", "lemonchiffon2", "lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2"), colsTxt = c("lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2", "black", "black", "black", 
    "black"), txtRot = 45, draw = drawTarget_ISSF300m), .Names = c("name", 
"unitTarget", "nRings", "maxVal", "convert", "cols", "colsTxt", 
"txtRot", "draw")), ISSF_200yd = structure(list(name = "ISSF 300m Rifle target adapted to 200yd", 
    unitTarget = "mm", nRings = 10, maxVal = 10, convert = structure(list(
        ringD10 = 57.82, ringD10i = 27.34, ringW = 30.48), .Names = c("ringD10", 
    "ringD10i", "ringW")), cols = c("black", "black", "black", 
    "black", "black", "black", "black", "lemonchiffon2", "lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2"), colsTxt = c("lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2", "black", "black", "black", 
    "black"), txtRot = 45, draw = drawTarget_ISSF300m), .Names = c("name", 
"unitTarget", "nRings", "maxVal", "convert", "cols", "colsTxt", 
"txtRot", "draw")), ISSF_300yd = structure(list(name = "ISSF 300m Rifle target adapted to 300yd", 
    unitTarget = "mm", nRings = 10, maxVal = 10, convert = structure(list(
        ringD10 = 90.75, ringD10i = 45.03, ringW = 45.72), .Names = c("ringD10", 
    "ringD10i", "ringW")), cols = c("black", "black", "black", 
    "black", "black", "black", "black", "lemonchiffon2", "lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2"), colsTxt = c("lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2", "black", "black", "black", 
    "black"), txtRot = 45, draw = drawTarget_ISSF300m), .Names = c("name", 
"unitTarget", "nRings", "maxVal", "convert", "cols", "colsTxt", 
"txtRot", "draw")), NRA_HPR_SR = structure(list(name = "NRA 200yd High Powered Rifle SR Military: Target, Rifle Competition, Short Range.", 
    unitTarget = "in", nRings = 6, maxVal = 10, convert = structure(list(
        ringD10 = 7, ringD10i = 3, ringW = 3), .Names = c("ringD10", 
    "ringD10i", "ringW")), cols = c("black", "black", "black", 
    "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", "lemonchiffon2"
    ), colsTxt = c("lemonchiffon2", "lemonchiffon2", "lemonchiffon2", 
    "black", "black", "black", "black"), draw = drawTarget_NRA_HPR), .Names = c("name", 
"unitTarget", "nRings", "maxVal", "convert", "cols", "colsTxt", 
"draw")), NRA_HPR_SR3 = structure(list(name = "NRA 300yd High Powered Rifle SR-3.", 
    unitTarget = "in", nRings = 6, maxVal = 10, convert = structure(list(
        ringD10 = 7, ringD10i = 3, ringW = 3), .Names = c("ringD10", 
    "ringD10i", "ringW")), cols = c("black", "black", "black", 
    "black", "lemonchiffon2", "lemonchiffon2", "lemonchiffon2"
    ), colsTxt = c("lemonchiffon2", "lemonchiffon2", "lemonchiffon2", 
    "lemonchiffon2", "black", "black", "black"), draw = drawTarget_NRA_HPR), .Names = c("name", 
"unitTarget", "nRings", "maxVal", "convert", "cols", "colsTxt", 
"draw")), NRA_P_B16 = structure(list(name = "NRA 25yd Pistol Slow Fire B-16.", 
    unitTarget = "in", nRings = 6, maxVal = 10, convert = structure(list(
        ringD10 = 1.51, ringD10i = 0.76, ringW = 0.545), .Names = c("ringD10", 
    "ringD10i", "ringW")), cols = c("black", "black", "black", 
    "black", "black", "lemonchiffon2", "lemonchiffon2"), colsTxt = c("lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", 
    "black", "black"), draw = drawTarget_NRA_HPR), .Names = c("name", 
"unitTarget", "nRings", "maxVal", "convert", "cols", "colsTxt", 
"draw")), DSB2 = structure(list(name = "DSB 15m Zimmerstutzen", 
    unitTarget = "mm", nRings = 10, maxVal = 10, convert = structure(list(
        ringD10 = 4.5, ringD10i = 4.5, ringW = 4.5), .Names = c("ringD10", 
    "ringD10i", "ringW")), cols = c("black", "black", "black", 
    "black", "black", "black", "lemonchiffon2", "lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2", "lemonchiffon2"), colsTxt = c("lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", 
    "lemonchiffon2", "black", "black", "black", "black", "black"
    )), .Names = c("name", "unitTarget", "nRings", "maxVal", 
"convert", "cols", "colsTxt")), DSB6 = structure(list(name = "DSB 50m Muskete Luntenschlossgewehr", 
    unitTarget = "mm", nRings = 6, maxVal = 10, convert = structure(list(
        ringD10 = 80, ringD10i = 80, ringW = 40), .Names = c("ringD10", 
    "ringD10i", "ringW")), cols = c("black", "black", "black", 
    "black", "black", "black", "lemonchiffon2"), colsTxt = c("lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", 
    "lemonchiffon2", "black")), .Names = c("name", "unitTarget", 
"nRings", "maxVal", "convert", "cols", "colsTxt")), DSB11 = structure(list(
    name = "DSB 10m Laufende Scheibe", unitTarget = "mm", nRings = 10, 
    maxVal = 10, convert = structure(list(ringD10 = 5.5, ringD10i = 0.5, 
        ringW = 2.5), .Names = c("ringD10", "ringD10i", "ringW"
    )), cols = c("black", "black", "black", "black", "black", 
    "black", "black", "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", 
    "lemonchiffon2"), colsTxt = c("lemonchiffon2", "lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", 
    "lemonchiffon2", "black", "black", "black", "black"), txtRot = 45, 
    draw = drawTarget_ISSF300m), .Names = c("name", "unitTarget", 
"nRings", "maxVal", "convert", "cols", "colsTxt", "txtRot", "draw"
)), BDS1 = structure(list(name = "BDS 100m", unitTarget = "mm", 
    nRings = 10, maxVal = 10, convert = structure(list(ringD10 = 34, 
        ringD10i = 17, ringW = 17), .Names = c("ringD10", "ringD10i", 
    "ringW")), cols = c("black", "black", "black", "black", "black", 
    "black", "black", "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", 
    "lemonchiffon2"), colsTxt = c("lemonchiffon2", "lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", 
    "lemonchiffon2", "black", "black", "black", "black")), .Names = c("name", 
"unitTarget", "nRings", "maxVal", "convert", "cols", "colsTxt"
)), BDS2 = structure(list(name = "BDS 50m Zielfernrohr", unitTarget = "mm", 
    nRings = 10, maxVal = 10, convert = structure(list(ringD10 = 19, 
        ringD10i = 9, ringW = 6), .Names = c("ringD10", "ringD10i", 
    "ringW")), cols = c("lemonchiffon2", "lemonchiffon2", "lemonchiffon2", 
    "black", "black", "black", "black", "lemonchiffon2", "lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2"), colsTxt = c("black", "black", 
    "black", "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", 
    "lemonchiffon2", "black", "black", "black", "black")), .Names = c("name", 
"unitTarget", "nRings", "maxVal", "convert", "cols", "colsTxt"
)), BDS4 = structure(list(name = "BDS 100m Zielfernrohr", unitTarget = "mm", 
    nRings = 10, maxVal = 10, convert = structure(list(ringD10 = 27, 
        ringD10i = 13.5, ringW = 8.5), .Names = c("ringD10", 
    "ringD10i", "ringW")), cols = c("lemonchiffon2", "lemonchiffon2", 
    "lemonchiffon2", "black", "black", "black", "black", "lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2", "lemonchiffon2"), colsTxt = c("black", 
    "black", "black", "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", 
    "lemonchiffon2", "black", "black", "black", "black")), .Names = c("name", 
"unitTarget", "nRings", "maxVal", "convert", "cols", "colsTxt"
)), BDS8 = structure(list(name = "BDS 300m Zielfernrohr", unitTarget = "mm", 
    nRings = 10, maxVal = 10, convert = structure(list(ringD10 = 86, 
        ringD10i = 35, ringW = 25), .Names = c("ringD10", "ringD10i", 
    "ringW")), cols = c("lemonchiffon2", "lemonchiffon2", "lemonchiffon2", 
    "black", "black", "black", "black", "lemonchiffon2", "lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2"), colsTxt = c("black", "black", 
    "black", "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", 
    "lemonchiffon2", "black", "black", "black", "black")), .Names = c("name", 
"unitTarget", "nRings", "maxVal", "convert", "cols", "colsTxt"
)), BDS9 = structure(list(name = "BDS 25m Kurzwaffe", unitTarget = "mm", 
    nRings = 10, maxVal = 10, convert = structure(list(ringD10 = 50, 
        ringD10i = 25, ringW = 25), .Names = c("ringD10", "ringD10i", 
    "ringW")), cols = c("lemonchiffon2", "lemonchiffon2", "lemonchiffon2", 
    "black", "black", "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2", "lemonchiffon2"), colsTxt = c("black", 
    "black", "black", "lemonchiffon2", "lemonchiffon2", "black", 
    "black", "black", "black", "black", "black")), .Names = c("name", 
"unitTarget", "nRings", "maxVal", "convert", "cols", "colsTxt"
)), BDMP1_25m = structure(list(name = "BDMP 25m .30 M1 Carbine", 
    unitTarget = "mm", nRings = 10, maxVal = 10, convert = structure(list(
        ringD10 = 8.5, ringD10i = 8.5, ringW = 4.25), .Names = c("ringD10", 
    "ringD10i", "ringW")), cols = c("black", "black", "black", 
    "black", "black", "black", "black", "lemonchiffon2", "lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2"), colsTxt = c("lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2", "black", "black", "black", 
    "black")), .Names = c("name", "unitTarget", "nRings", "maxVal", 
"convert", "cols", "colsTxt")), BDMP1_50m = structure(list(name = "BDMP 50m .30 M1 Carbine", 
    unitTarget = "mm", nRings = 10, maxVal = 10, convert = structure(list(
        ringD10 = 17, ringD10i = 8.5, ringW = 8.25), .Names = c("ringD10", 
    "ringD10i", "ringW")), cols = c("black", "black", "black", 
    "black", "black", "black", "black", "lemonchiffon2", "lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2"), colsTxt = c("lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2", "black", "black", "black", 
    "black")), .Names = c("name", "unitTarget", "nRings", "maxVal", 
"convert", "cols", "colsTxt")), BDMP1_100m = structure(list(name = "BDMP 100m SG 1, CISM-Gewehr, .30 M1 Carbine", 
    unitTarget = "mm", nRings = 10, maxVal = 10, convert = structure(list(
        ringD10 = 34, ringD10i = 17, ringW = 16.5), .Names = c("ringD10", 
    "ringD10i", "ringW")), cols = c("black", "black", "black", 
    "black", "black", "black", "black", "lemonchiffon2", "lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2"), colsTxt = c("lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2", "black", "black", "black", 
    "black")), .Names = c("name", "unitTarget", "nRings", "maxVal", 
"convert", "cols", "colsTxt")), BDMP3 = structure(list(name = "BDMP ZG 1", 
    unitTarget = "mm", nRings = 4, maxVal = 5, convert = structure(list(
        ringD10 = 30, ringD10i = 20, ringW = 10, extra = 60), .Names = c("ringD10", 
    "ringD10i", "ringW", "extra")), cols = c("lemonchiffon2", 
    "black", "lemonchiffon2", "lemonchiffon2", "lemonchiffon2"
    ), colsTxt = c("black", "lemonchiffon2", "lemonchiffon2", 
    "gray50", "black"), draw = drawTarget_BDMP3), .Names = c("name", 
"unitTarget", "nRings", "maxVal", "convert", "cols", "colsTxt", 
"draw")), BDMP4 = structure(list(name = "BDMP ZG 2, ZG 3, ZG 4", 
    unitTarget = "mm", nRings = 4, maxVal = 5, convert = structure(list(
        ringD10 = 60, ringD10i = 30, ringW = 20, extra = 180), .Names = c("ringD10", 
    "ringD10i", "ringW", "extra")), cols = c("lemonchiffon2", 
    "lemonchiffon2", "black", "black", "black"), colsTxt = c("black", 
    "black", "lemonchiffon2", "lemonchiffon2", "lemonchiffon2"
    ), draw = drawTarget_BDMP4, countMouche = TRUE), .Names = c("name", 
"unitTarget", "nRings", "maxVal", "convert", "cols", "colsTxt", 
"draw", "countMouche")), BDMP5 = structure(list(name = "BDMP 300m DG 3, DG 4", 
    unitTarget = "mm", nRings = 6, maxVal = 10, convert = structure(list(
        ringD10 = 150, ringD10i = 75, ringW = 75), .Names = c("ringD10", 
    "ringD10i", "ringW")), cols = c("lemonchiffon2", "lemonchiffon2", 
    "black", "black", "black", "lemonchiffon2", "lemonchiffon2"
    ), colsTxt = c("black", "black", "lemonchiffon2", "lemonchiffon2", 
    "lemonchiffon2", "black", "black"), txtRot = 45, draw = drawTarget_ISSF300m), .Names = c("name", 
"unitTarget", "nRings", "maxVal", "convert", "cols", "colsTxt", 
"txtRot", "draw")), DSUb2 = structure(list(name = "DSU b2", unitTarget = "mm", 
    nRings = 10, maxVal = 10, convert = structure(list(ringD10 = 65, 
        ringD10V = 102, ringD10i = 32, ringD10Vi = 51, ringW = 16, 
        ringWV = 25), .Names = c("ringD10", "ringD10V", "ringD10i", 
    "ringD10Vi", "ringW", "ringWV")), cols = c("ghostwhite", 
    "ghostwhite", "ghostwhite", "springgreen4", "springgreen4", 
    "springgreen4", "springgreen4", "ghostwhite", "ghostwhite", 
    "ghostwhite", "ghostwhite"), colsTxt = c("springgreen4", 
    "springgreen4", "springgreen4", "ghostwhite", "ghostwhite", 
    "ghostwhite", "ghostwhite", "springgreen4", "springgreen4", 
    "springgreen4", "springgreen4"), colPt = "lemonchiffon2", 
    draw = drawTarget_DSUb, simRingCount = simRingCount_DSUb), .Names = c("name", 
"unitTarget", "nRings", "maxVal", "convert", "cols", "colsTxt", 
"colPt", "draw", "simRingCount")), DSUb3 = structure(list(name = "DSU b3", 
    unitTarget = "mm", nRings = 10, maxVal = 10, convert = structure(list(
        ringD10 = 45, ringD10V = 69, ringD10i = 23, ringD10Vi = 34, 
        ringW = 11, ringWV = 17), .Names = c("ringD10", "ringD10V", 
    "ringD10i", "ringD10Vi", "ringW", "ringWV")), cols = c("ghostwhite", 
    "ghostwhite", "ghostwhite", "springgreen4", "springgreen4", 
    "springgreen4", "springgreen4", "ghostwhite", "ghostwhite", 
    "ghostwhite", "ghostwhite"), colsTxt = c("springgreen4", 
    "springgreen4", "springgreen4", "ghostwhite", "ghostwhite", 
    "ghostwhite", "ghostwhite", "springgreen4", "springgreen4", 
    "springgreen4", "springgreen4"), colPt = "lemonchiffon2", 
    draw = drawTarget_DSUb, simRingCount = simRingCount_DSUb), .Names = c("name", 
"unitTarget", "nRings", "maxVal", "convert", "cols", "colsTxt", 
"colPt", "draw", "simRingCount")), DSUb4 = structure(list(name = "DSU b4", 
    unitTarget = "mm", nRings = 10, maxVal = 10, convert = structure(list(
        ringD10 = 33, ringD10V = 51, ringD10i = 16, ringD10Vi = 25, 
        ringW = 8, ringWV = 12), .Names = c("ringD10", "ringD10V", 
    "ringD10i", "ringD10Vi", "ringW", "ringWV")), cols = c("ghostwhite", 
    "ghostwhite", "ghostwhite", "springgreen4", "springgreen4", 
    "springgreen4", "springgreen4", "ghostwhite", "ghostwhite", 
    "ghostwhite", "ghostwhite"), colsTxt = c("springgreen4", 
    "springgreen4", "springgreen4", "ghostwhite", "ghostwhite", 
    "ghostwhite", "ghostwhite", "springgreen4", "springgreen4", 
    "springgreen4", "springgreen4"), colPt = "lemonchiffon2", 
    draw = drawTarget_DSUb, simRingCount = simRingCount_DSUb), .Names = c("name", 
"unitTarget", "nRings", "maxVal", "convert", "cols", "colsTxt", 
"colPt", "draw", "simRingCount")), DSUb5 = structure(list(name = "DSU b5", 
    unitTarget = "mm", nRings = 10, maxVal = 10, convert = structure(list(
        ringD10 = 23, ringD10V = 35, ringD10i = 11, ringD10Vi = 18, 
        ringW = 5.8, ringWV = 9), .Names = c("ringD10", "ringD10V", 
    "ringD10i", "ringD10Vi", "ringW", "ringWV")), cols = c("ghostwhite", 
    "ghostwhite", "ghostwhite", "springgreen4", "springgreen4", 
    "springgreen4", "springgreen4", "ghostwhite", "ghostwhite", 
    "ghostwhite", "ghostwhite"), colsTxt = c("springgreen4", 
    "springgreen4", "springgreen4", "ghostwhite", "ghostwhite", 
    "ghostwhite", "ghostwhite", "springgreen4", "springgreen4", 
    "springgreen4", "springgreen4"), colPt = "lemonchiffon2", 
    draw = drawTarget_DSUb, simRingCount = simRingCount_DSUb), .Names = c("name", 
"unitTarget", "nRings", "maxVal", "convert", "cols", "colsTxt", 
"colPt", "draw", "simRingCount")), DSUb5P = structure(list(name = "DSU b5 Praezision", 
    unitTarget = "mm", nRings = 10, maxVal = 10, convert = structure(list(
        ringD10 = 17, ringD10V = 26, ringD10i = 8.5, ringD10Vi = 13, 
        ringW = 4.3, ringWV = 6.8), .Names = c("ringD10", "ringD10V", 
    "ringD10i", "ringD10Vi", "ringW", "ringWV")), cols = c("ghostwhite", 
    "ghostwhite", "ghostwhite", "springgreen4", "springgreen4", 
    "springgreen4", "springgreen4", "ghostwhite", "ghostwhite", 
    "ghostwhite", "ghostwhite"), colsTxt = c("springgreen4", 
    "springgreen4", "springgreen4", "ghostwhite", "ghostwhite", 
    "ghostwhite", "ghostwhite", "springgreen4", "springgreen4", 
    "springgreen4", "springgreen4"), colPt = "lemonchiffon2", 
    draw = drawTarget_DSUb, simRingCount = simRingCount_DSUb), .Names = c("name", 
"unitTarget", "nRings", "maxVal", "convert", "cols", "colsTxt", 
"colPt", "draw", "simRingCount")), DSU_200mP = structure(list(
    name = "DSU 200m Praezision", unitTarget = "mm", nRings = 10, 
    maxVal = 10, convert = structure(list(ringD10 = 80, ringD10i = 40, 
        ringW = 40), .Names = c("ringD10", "ringD10i", "ringW"
    )), cols = c("black", "black", "black", "black", "black", 
    "black", "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2"), colsTxt = c("lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", 
    "lemonchiffon2", "black", "black", "black", "black", "black"
    )), .Names = c("name", "unitTarget", "nRings", "maxVal", 
"convert", "cols", "colsTxt")), DSUa2 = structure(list(name = "DSU a2", 
    unitTarget = "mm", nRings = 3, maxVal = 10, convert = structure(list(
        ringD10 = 68, ringD10V = 106, ringD10i = 20, ringD9 = 170, 
        ringD9V = 265, ringD9thick = 2, ringD8 = 340, ringD8V = 530, 
        ringD8thick = 3.2, ringOffDi = 50, ringOffD = 110, ringOff = 15, 
        crossW = 6, crossThick = 1.5, angleOff = 29, angleL = 9, 
        angleThick = 0.5), .Names = c("ringD10", "ringD10V", 
    "ringD10i", "ringD9", "ringD9V", "ringD9thick", "ringD8", 
    "ringD8V", "ringD8thick", "ringOffDi", "ringOffD", "ringOff", 
    "crossW", "crossThick", "angleOff", "angleL", "angleThick"
    )), cols = c("ghostwhite", "springgreen4"), colsTxt = c("springgreen4", 
    "springgreen4", "springgreen4", "ghostwhite", "ghostwhite", 
    "ghostwhite", "ghostwhite", "springgreen4", "springgreen4", 
    "springgreen4", "springgreen4"), colPt = "lemonchiffon2", 
    draw = drawTarget_DSUa, simRingCount = simRingCount_DSUa), .Names = c("name", 
"unitTarget", "nRings", "maxVal", "convert", "cols", "colsTxt", 
"colPt", "draw", "simRingCount")), ISSF_100m = structure(list(
    name = "ISSF 100m Rifle", unitTarget = "mm", nRings = 10, 
    maxVal = 10, convert = structure(list(ringD10 = 50, ringD10i = 25, 
        ringW = 25), .Names = c("ringD10", "ringD10i", "ringW"
    )), cols = c("black", "black", "black", "black", "black", 
    "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2"), colsTxt = c("lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", 
    "black", "black", "black", "black", "black", "black")), .Names = c("name", 
"unitTarget", "nRings", "maxVal", "convert", "cols", "colsTxt"
)), DSB1 = structure(list(name = "DSB 10m Luftgewehr", unitTarget = "mm", 
    nRings = 10, maxVal = 10, convert = structure(list(ringD10 = 0.5, 
        ringD10i = 0.5, ringW = 2.5), .Names = c("ringD10", "ringD10i", 
    "ringW")), cols = c("black", "black", "black", "black", "black", 
    "black", "black", "black", "lemonchiffon2", "lemonchiffon2", 
    "lemonchiffon2"), colsTxt = c("lemonchiffon2", "lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2", "black", "black", "black"
    )), .Names = c("name", "unitTarget", "nRings", "maxVal", 
"convert", "cols", "colsTxt")), DSB3 = structure(list(name = "DSB 50m Kleinkalibergewehr", 
    unitTarget = "mm", nRings = 10, maxVal = 10, convert = structure(list(
        ringD10 = 10.4, ringD10i = 5, ringW = 8, extra = 56.2), .Names = c("ringD10", 
    "ringD10i", "ringW", "extra")), cols = c("black", "black", 
    "black", "black", "black", "black", "black", "black", "lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2"), colsTxt = c("lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", "black", 
    "black", "black"), draw = drawTarget_ISSF50m), .Names = c("name", 
"unitTarget", "nRings", "maxVal", "convert", "cols", "colsTxt", 
"draw")), DSB4 = structure(list(name = "DSB 100m Kleinkalibergewehr, 25m Pistole, 50m Pistole", 
    unitTarget = "mm", nRings = 10, maxVal = 10, convert = structure(list(
        ringD10 = 50, ringD10i = 25, ringW = 25), .Names = c("ringD10", 
    "ringD10i", "ringW")), cols = c("black", "black", "black", 
    "black", "black", "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2", "lemonchiffon2"), colsTxt = c("lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", 
    "black", "black", "black", "black", "black", "black")), .Names = c("name", 
"unitTarget", "nRings", "maxVal", "convert", "cols", "colsTxt"
)), DSB5 = structure(list(name = "DSB 300m Gewehr/Vorderlader Freigewehr", 
    unitTarget = "mm", nRings = 10, maxVal = 10, convert = structure(list(
        ringD10 = 100, ringD10i = 50, ringW = 50), .Names = c("ringD10", 
    "ringD10i", "ringW")), cols = c("black", "black", "black", 
    "black", "black", "black", "black", "lemonchiffon2", "lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2"), colsTxt = c("lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2", "black", "black", "black", 
    "black"), txtRot = 45, draw = drawTarget_ISSF300m), .Names = c("name", 
"unitTarget", "nRings", "maxVal", "convert", "cols", "colsTxt", 
"txtRot", "draw")), DSB7 = structure(list(name = "DSB 10m Luftpistole", 
    unitTarget = "mm", nRings = 10, maxVal = 10, convert = structure(list(
        ringD10 = 11.5, ringD10i = 5, ringW = 8), .Names = c("ringD10", 
    "ringD10i", "ringW")), cols = c("black", "black", "black", 
    "black", "black", "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2", "lemonchiffon2"), colsTxt = c("lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", 
    "black", "black", "black", "black", "black", "black")), .Names = c("name", 
"unitTarget", "nRings", "maxVal", "convert", "cols", "colsTxt"
)), DSB9 = structure(list(name = "DSB 25m Schnellfeuerpistole, 25m Pistole Duell", 
    unitTarget = "mm", nRings = 6, maxVal = 10, convert = structure(list(
        ringD10 = 100, ringD10i = 50, ringW = 40, extra = 5), .Names = c("ringD10", 
    "ringD10i", "ringW", "extra")), cols = c("black", "black", 
    "black", "black", "black", "black", "black"), colsTxt = c("lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2"), draw = drawTarget_ISSF25mRF), .Names = c("name", 
"unitTarget", "nRings", "maxVal", "convert", "cols", "colsTxt", 
"draw")), BDS3 = structure(list(name = "BDS 50m", unitTarget = "mm", 
    nRings = 10, maxVal = 10, convert = structure(list(ringD10 = 10.4, 
        ringD10i = 5, ringW = 8, extra = 56.2), .Names = c("ringD10", 
    "ringD10i", "ringW", "extra")), cols = c("black", "black", 
    "black", "black", "black", "black", "black", "black", "lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2"), colsTxt = c("lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", "black", 
    "black", "black"), draw = drawTarget_ISSF50m), .Names = c("name", 
"unitTarget", "nRings", "maxVal", "convert", "cols", "colsTxt", 
"draw")), BDS5 = structure(list(name = "BDS Pistole 25m, Pistole 50m", 
    unitTarget = "mm", nRings = 10, maxVal = 10, convert = structure(list(
        ringD10 = 50, ringD10i = 25, ringW = 25), .Names = c("ringD10", 
    "ringD10i", "ringW")), cols = c("black", "black", "black", 
    "black", "black", "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2", "lemonchiffon2"), colsTxt = c("lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", 
    "black", "black", "black", "black", "black", "black")), .Names = c("name", 
"unitTarget", "nRings", "maxVal", "convert", "cols", "colsTxt"
)), BDS7 = structure(list(name = "BDS 300m", unitTarget = "mm", 
    nRings = 10, maxVal = 10, convert = structure(list(ringD10 = 100, 
        ringD10i = 50, ringW = 50), .Names = c("ringD10", "ringD10i", 
    "ringW")), cols = c("black", "black", "black", "black", "black", 
    "black", "black", "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", 
    "lemonchiffon2"), colsTxt = c("lemonchiffon2", "lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", 
    "lemonchiffon2", "black", "black", "black", "black"), txtRot = 45, 
    draw = drawTarget_ISSF300m), .Names = c("name", "unitTarget", 
"nRings", "maxVal", "convert", "cols", "colsTxt", "txtRot", "draw"
)), BDS13 = structure(list(name = "BDS 10m Luftgewehr", unitTarget = "mm", 
    nRings = 10, maxVal = 10, convert = structure(list(ringD10 = 0.5, 
        ringD10i = 0.5, ringW = 2.5), .Names = c("ringD10", "ringD10i", 
    "ringW")), cols = c("black", "black", "black", "black", "black", 
    "black", "black", "black", "lemonchiffon2", "lemonchiffon2", 
    "lemonchiffon2"), colsTxt = c("lemonchiffon2", "lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2", "black", "black", "black"
    )), .Names = c("name", "unitTarget", "nRings", "maxVal", 
"convert", "cols", "colsTxt")), BDS14 = structure(list(name = "BDS 10m Luftpistole", 
    unitTarget = "mm", nRings = 10, maxVal = 10, convert = structure(list(
        ringD10 = 11.5, ringD10i = 5, ringW = 8), .Names = c("ringD10", 
    "ringD10i", "ringW")), cols = c("black", "black", "black", 
    "black", "black", "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2", "lemonchiffon2"), colsTxt = c("lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", 
    "black", "black", "black", "black", "black", "black")), .Names = c("name", 
"unitTarget", "nRings", "maxVal", "convert", "cols", "colsTxt"
)), BDMP2 = structure(list(name = "BDMP 300m SG 2, CISM-Gewehr, DG 2, FG 1, PVDG 1, PHDG 1, SDG 1, SDG 2, PFG 1, SPPDG 1", 
    unitTarget = "mm", nRings = 10, maxVal = 10, convert = structure(list(
        ringD10 = 100, ringD10i = 50, ringW = 50), .Names = c("ringD10", 
    "ringD10i", "ringW")), cols = c("black", "black", "black", 
    "black", "black", "black", "black", "lemonchiffon2", "lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2"), colsTxt = c("lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2", "black", "black", "black", 
    "black"), txtRot = 45, draw = drawTarget_ISSF300m), .Names = c("name", 
"unitTarget", "nRings", "maxVal", "convert", "cols", "colsTxt", 
"txtRot", "draw")), DSU_UITP = structure(list(name = "DSU UIT Praezision", 
    unitTarget = "mm", nRings = 10, maxVal = 10, convert = structure(list(
        ringD10 = 50, ringD10i = 25, ringW = 25), .Names = c("ringD10", 
    "ringD10i", "ringW")), cols = c("black", "black", "black", 
    "black", "black", "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2", "lemonchiffon2"), colsTxt = c("lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", 
    "black", "black", "black", "black", "black", "black")), .Names = c("name", 
"unitTarget", "nRings", "maxVal", "convert", "cols", "colsTxt"
)), DSU_KKI = structure(list(name = "DSU KK international", unitTarget = "mm", 
    nRings = 10, maxVal = 10, convert = structure(list(ringD10 = 10.4, 
        ringD10i = 5, ringW = 8, extra = 56.2), .Names = c("ringD10", 
    "ringD10i", "ringW", "extra")), cols = c("black", "black", 
    "black", "black", "black", "black", "black", "black", "lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2"), colsTxt = c("lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", 
    "lemonchiffon2", "lemonchiffon2", "lemonchiffon2", "black", 
    "black", "black"), draw = drawTarget_ISSF50m), .Names = c("name", 
"unitTarget", "nRings", "maxVal", "convert", "cols", "colsTxt", 
"draw"))), .Names = c("ISSF_10mAR", "ISSF_10mAP", "ISSF_25mPP", 
"ISSF_25mRFP", "ISSF_50m", "ISSF_300m", "ISSF_50ftPP", "ISSF_50ftSP", 
"ISSF_25ydPP", "ISSF_50ydPP", "ISSF_25ydRFP", "ISSF_50ftRFP", 
"ISSF_50ft", "ISSF_50yd", "ISSF_100yd", "ISSF_200yd", "ISSF_300yd", 
"NRA_HPR_SR", "NRA_HPR_SR3", "NRA_P_B16", "DSB2", "DSB6", "DSB11", 
"BDS1", "BDS2", "BDS4", "BDS8", "BDS9", "BDMP1_25m", "BDMP1_50m", 
"BDMP1_100m", "BDMP3", "BDMP4", "BDMP5", "DSUb2", "DSUb3", "DSUb4", 
"DSUb5", "DSUb5P", "DSU_200mP", "DSUa2", "ISSF_100m", "DSB1", 
"DSB3", "DSB4", "DSB5", "DSB7", "DSB9", "BDS3", "BDS5", "BDS7", 
"BDS13", "BDS14", "BDMP2", "DSU_UITP", "DSU_KKI"))
